/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelAfricanBuffalo;
import net.abyssoul.abyssoulswildlife.client.model.animations.AfricanBuffaloAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.AfricanBuffaloEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AfricanBuffaloRenderer
extends MobRenderer<AfricanBuffaloEntity, ModelAfricanBuffalo<AfricanBuffaloEntity>> {
    public AfricanBuffaloRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAfricanBuffalo.LAYER_LOCATION)), 1.5f);
    }

    protected void scale(AfricanBuffaloEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AfricanBuffaloEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/african_buffalo.png");
    }

    private static final class AnimatedModel
    extends ModelAfricanBuffalo<AfricanBuffaloEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AfricanBuffaloEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AfricanBuffaloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AfricanBuffaloAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.0f);
                this.animate(entity.animationState1, AfricanBuffaloAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState2, AfricanBuffaloAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState4, AfricanBuffaloAnimation.idle2, ageInTicks, 1.0f);
                this.animate(entity.animationState5, AfricanBuffaloAnimation.charge, ageInTicks, 1.0f);
                this.animate(entity.animationState6, AfricanBuffaloAnimation.isBaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AfricanBuffaloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

