/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelLion;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.JaguarAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.LionAnimation;
import net.abyssoul.abyssoulswildlife.entity.AfricanLionEntity;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionIsMaleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionSizeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarRunAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarWalkAnimProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AfricanLionRenderer
extends MobRenderer<AfricanLionEntity, ModelLion<AfricanLionEntity>> {
    public AfricanLionRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelLion.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<AfricanLionEntity, ModelLion<AfricanLionEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/lion_mane.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, AfricanLionEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (AfricanLionIsMaleProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelLion)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(AfricanLionEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)AfricanLionSizeProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AfricanLionEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/lioness.png");
    }

    private static final class AnimatedModel
    extends ModelLion<AfricanLionEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AfricanLionEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AfricanLionEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, JaguarAnimation.idle, ageInTicks, 1.0f);
                if (JaguarWalkAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(LionAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.5f);
                }
                if (JaguarRunAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(LionAnimation.run, limbSwing, limbSwingAmount, 1.8f, 1.4f);
                }
                this.animate(entity.animationState3, LionAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState4, LionAnimation.claw, ageInTicks, 1.0f);
                this.animate(entity.animationState5, LionAnimation.leap, ageInTicks, 1.0f);
                this.animate(entity.animationState6, LionAnimation.rest, ageInTicks, 1.0f);
                this.animate(entity.animationState7, LionAnimation.parry, ageInTicks, 1.0f);
                this.animate(entity.animationState8, LionAnimation.roar, ageInTicks, 1.0f);
                this.animate(entity.animationState9, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AfricanLionEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

