/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelAligatorGar;
import net.abyssoul.abyssoulswildlife.client.model.animations.AligatorGarAnimation;
import net.abyssoul.abyssoulswildlife.entity.AligatorGarEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AligatorGarRenderer
extends MobRenderer<AligatorGarEntity, ModelAligatorGar<AligatorGarEntity>> {
    public AligatorGarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAligatorGar.LAYER_LOCATION)), 1.0f);
    }

    protected void scale(AligatorGarEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AligatorGarEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/aligator_gar.png");
    }

    private static final class AnimatedModel
    extends ModelAligatorGar<AligatorGarEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AligatorGarEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AligatorGarEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AligatorGarAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.0f);
                this.animate(entity.animationState1, AligatorGarAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AligatorGarEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

