/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelAncientLeshen;
import net.abyssoul.abyssoulswildlife.client.model.animations.AncientLeshenAnimation;
import net.abyssoul.abyssoulswildlife.entity.AncientLeshenEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;

public class AncientLeshenRenderer
extends MobRenderer<AncientLeshenEntity, ModelAncientLeshen<AncientLeshenEntity>> {
    public AncientLeshenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAncientLeshen.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<AncientLeshenEntity, ModelAncientLeshen<AncientLeshenEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/ancient_leshen_eye.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, AncientLeshenEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelAncientLeshen)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public void render(AncientLeshenEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity entity;
        boolean shouldSit;
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))).isCanceled()) {
            return;
        }
        matrixStackIn.pushPose();
        ((ModelAncientLeshen)this.model).attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        ((ModelAncientLeshen)this.model).riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        ((ModelAncientLeshen)this.model).young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f7 = Mth.wrapDegrees((float)f2);
            if (f7 < -85.0f) {
                f7 = -85.0f;
            }
            if (f7 >= 85.0f) {
                f7 = 85.0f;
            }
            f = f1 - f7;
            if (f7 * f7 > 2500.0f) {
                f += f7 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (AncientLeshenRenderer.isEntityUpsideDown((LivingEntity)entityIn)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        f2 = Mth.wrapDegrees((float)f2);
        if (entityIn.hasPose(Pose.SLEEPING) && (direction = entityIn.getBedOrientation()) != null) {
            float f3 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((float)(-direction.getStepX()) * f3, 0.0f, (float)(-direction.getStepZ()) * f3);
        }
        float f8 = entityIn.getScale();
        matrixStackIn.scale(f8, f8, f8);
        float f9 = this.getBob((LivingEntity)entityIn, partialTicks);
        this.setupRotations((LivingEntity)entityIn, matrixStackIn, f9, f, partialTicks, f8);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0f, -1.501f, 0.0f);
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f4 = entityIn.walkAnimation.speed(partialTicks);
            f5 = entityIn.walkAnimation.position(partialTicks);
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
        }
        ((ModelAncientLeshen)this.model).prepareMobModel((Entity)entityIn, f5, f4, partialTicks);
        ((ModelAncientLeshen)this.model).setupAnim(entityIn, f5, f4, f9, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = entityIn.isDeadOrDying() || entityIn.IsTeleporting() ? false : this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)entityIn);
        RenderType rendertype = this.getRenderType((LivingEntity)entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            int i;
            VertexConsumer vertexconsumer = bufferIn.getBuffer(rendertype);
            int n = i = entityIn.isDeadOrDying() ? OverlayTexture.NO_OVERLAY : AncientLeshenRenderer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
            int alpha = entityIn.bossDeathTime > 50 ? Math.max(3, 255 - (entityIn.bossDeathTime - 50) * 510 / entityIn.bossDeathTime) : (entityIn.IsTeleporting() ? Math.max(3, 255 - (120 - entityIn.TeleportingProgress()) * 5) : 255);
            int i1 = FastColor.ARGB32.color((int)alpha, (int)255, (int)255, (int)255);
            ((ModelAncientLeshen)this.model).renderToBuffer(matrixStackIn, vertexconsumer, packedLightIn, i, flag1 ? i1 : -1);
        }
        if (!entityIn.isSpectator()) {
            for (RenderLayer renderlayer : this.layers) {
                renderlayer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f4, partialTicks, f9, f2, f6);
            }
        }
        matrixStackIn.popPose();
        this.renderetc(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    private void renderetc(AncientLeshenEntity p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        RenderNameTagEvent event = new RenderNameTagEvent((Entity)p_entity, p_entity.getDisplayName(), (EntityRenderer)this, poseStack, bufferSource, packedLight, partialTick);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.canRender().isTrue() || event.canRender().isDefault() && this.shouldShowName((Mob)p_entity)) {
            this.renderNameTag((Entity)p_entity, event.getContent(), poseStack, bufferSource, packedLight, partialTick);
        }
    }

    public ResourceLocation getTextureLocation(AncientLeshenEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/ancient_leshen.png");
    }

    private static final class AnimatedModel
    extends ModelAncientLeshen<AncientLeshenEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AncientLeshenEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AncientLeshenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AncientLeshenAnimation.walk, limbSwing, limbSwingAmount, 2.5f, 3.5f);
                this.animate(entity.animationState1, AncientLeshenAnimation.claw1, ageInTicks, 1.0f);
                this.animate(entity.animationState2, AncientLeshenAnimation.claw1_1, ageInTicks, 1.0f);
                this.animate(entity.animationState3, AncientLeshenAnimation.claw2, ageInTicks, 1.0f);
                this.animate(entity.animationState4, AncientLeshenAnimation.hug, ageInTicks, 1.0f);
                this.animate(entity.animationState5, AncientLeshenAnimation.quickclaw, ageInTicks, 1.0f);
                this.animate(entity.animationState6, AncientLeshenAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState7, AncientLeshenAnimation.summonthorn, ageInTicks, 1.0f);
                this.animate(entity.animationState8, AncientLeshenAnimation.summon_crow, ageInTicks, 1.0f);
                this.animate(entity.animationState9, AncientLeshenAnimation.teleport, ageInTicks, 1.0f);
                this.animate(entity.animationState10, AncientLeshenAnimation.roar, ageInTicks, 1.0f);
                this.animate(entity.animationState11, AncientLeshenAnimation.summonanimal, ageInTicks, 1.0f);
                this.animate(entity.animationState12, AncientLeshenAnimation.burned, ageInTicks, 1.0f);
                this.animate(entity.animationState13, AncientLeshenAnimation.finalkill, ageInTicks, 1.0f);
                this.animate(entity.animationState14, AncientLeshenAnimation.death, ageInTicks, 0.6f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AncientLeshenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

