/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelAnglerFish;
import net.abyssoul.abyssoulswildlife.client.model.animations.AnglerFishAnimation;
import net.abyssoul.abyssoulswildlife.entity.AnglerFishEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AnglerFishRenderer
extends MobRenderer<AnglerFishEntity, ModelAnglerFish<AnglerFishEntity>> {
    public AnglerFishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAnglerFish.LAYER_LOCATION)), 0.3f);
        this.addLayer((RenderLayer)new RenderLayer<AnglerFishEntity, ModelAnglerFish<AnglerFishEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/anglerfish_glow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, AnglerFishEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelAnglerFish)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    protected void scale(AnglerFishEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AnglerFishEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/anglerfish.png");
    }

    private static final class AnimatedModel
    extends ModelAnglerFish<AnglerFishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AnglerFishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AnglerFishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AnglerFishAnimation.swim, limbSwing, limbSwingAmount, 2.0f, 2.0f);
                this.animate(entity.animationState1, AnglerFishAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AnglerFishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

