/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelAntarcticSleeperShark;
import net.abyssoul.abyssoulswildlife.client.model.animations.AntarcticSleeperSharkAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.TigerSharkAnimation;
import net.abyssoul.abyssoulswildlife.entity.AntarcticSleeperSharkEntity;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AntarcticSleeperSharkRenderer
extends MobRenderer<AntarcticSleeperSharkEntity, ModelAntarcticSleeperShark<AntarcticSleeperSharkEntity>> {
    public AntarcticSleeperSharkRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAntarcticSleeperShark.LAYER_LOCATION)), 1.4f);
    }

    protected void scale(AntarcticSleeperSharkEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)SleeperSharkScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AntarcticSleeperSharkEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/antarctic_sleepershark.png");
    }

    private static final class AnimatedModel
    extends ModelAntarcticSleeperShark<AntarcticSleeperSharkEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AntarcticSleeperSharkEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AntarcticSleeperSharkEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AntarcticSleeperSharkAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, AntarcticSleeperSharkAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, TigerSharkAnimation.stranded, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AntarcticSleeperSharkEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

