/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelArapaima;
import net.abyssoul.abyssoulswildlife.client.model.animations.AligatorGarAnimation;
import net.abyssoul.abyssoulswildlife.entity.ArapaimaEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ArapaimaRenderer
extends MobRenderer<ArapaimaEntity, ModelArapaima<ArapaimaEntity>> {
    public ArapaimaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelArapaima.LAYER_LOCATION)), 1.1f);
    }

    protected void scale(ArapaimaEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ArapaimaEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/arapaima.png");
    }

    private static final class AnimatedModel
    extends ModelArapaima<ArapaimaEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ArapaimaEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ArapaimaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AligatorGarAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.0f);
                this.animate(entity.animationState1, AligatorGarAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ArapaimaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

