/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelAsiaticBlackBear;
import net.abyssoul.abyssoulswildlife.client.model.animations.AsiaticBlackBearAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.AsiaticBlackBearEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AsiaticBlackBearRenderer
extends MobRenderer<AsiaticBlackBearEntity, ModelAsiaticBlackBear<AsiaticBlackBearEntity>> {
    public AsiaticBlackBearRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAsiaticBlackBear.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(AsiaticBlackBearEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.25f, 1.25f, 1.25f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AsiaticBlackBearEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/asiatic_black_bear.png");
    }

    private static final class AnimatedModel
    extends ModelAsiaticBlackBear<AsiaticBlackBearEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AsiaticBlackBearEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AsiaticBlackBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(AsiaticBlackBearAnimation.walk, limbSwing, limbSwingAmount, 3.0f, 2.5f);
                this.animate(entity.animationState1, AsiaticBlackBearAnimation.claw, ageInTicks, 1.0f);
                this.animate(entity.animationState2, AsiaticBlackBearAnimation.claw2, ageInTicks, 1.0f);
                this.animate(entity.animationState3, AsiaticBlackBearAnimation.claw3, ageInTicks, 1.0f);
                this.animate(entity.animationState4, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AsiaticBlackBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

