/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelBelugaWhale;
import net.abyssoul.abyssoulswildlife.client.model.animations.BelugaWhaleAnimation;
import net.abyssoul.abyssoulswildlife.entity.BelugaWhaleEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BelugaWhaleRenderer
extends MobRenderer<BelugaWhaleEntity, ModelBelugaWhale<BelugaWhaleEntity>> {
    public BelugaWhaleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBelugaWhale.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(BelugaWhaleEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BelugaWhaleEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/beluga_whale.png");
    }

    private static final class AnimatedModel
    extends ModelBelugaWhale<BelugaWhaleEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BelugaWhaleEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BelugaWhaleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(BelugaWhaleAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, BelugaWhaleAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BelugaWhaleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

