/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelBlackMamba;
import net.abyssoul.abyssoulswildlife.client.model.animations.BlackMambaAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.BlackMambaEntity;
import net.abyssoul.abyssoulswildlife.procedures.BlackMambaSkin1Procedure;
import net.abyssoul.abyssoulswildlife.procedures.BlackMambaSkin2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BlackMambaRenderer
extends MobRenderer<BlackMambaEntity, ModelBlackMamba<BlackMambaEntity>> {
    public BlackMambaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBlackMamba.LAYER_LOCATION)), 0.6f);
        this.addLayer((RenderLayer)new RenderLayer<BlackMambaEntity, ModelBlackMamba<BlackMambaEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/black_mamba1.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, BlackMambaEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (BlackMambaSkin1Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelBlackMamba)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<BlackMambaEntity, ModelBlackMamba<BlackMambaEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/black_mamba2.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, BlackMambaEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (BlackMambaSkin2Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelBlackMamba)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(BlackMambaEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BlackMambaEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/black_mamba.png");
    }

    private static final class AnimatedModel
    extends ModelBlackMamba<BlackMambaEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BlackMambaEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BlackMambaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(BlackMambaAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, BlackMambaAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, BlackMambaAnimation.ah, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BlackMambaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

