/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelGrizzlyBear;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GrizzlyBearAnimation;
import net.abyssoul.abyssoulswildlife.entity.BrownBearEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BrownBearRenderer
extends MobRenderer<BrownBearEntity, ModelGrizzlyBear<BrownBearEntity>> {
    public BrownBearRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGrizzlyBear.LAYER_LOCATION)), 1.0f);
    }

    protected void scale(BrownBearEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.6f, 1.6f, 1.6f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BrownBearEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/grizzly_bear.png");
    }

    private static final class AnimatedModel
    extends ModelGrizzlyBear<BrownBearEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BrownBearEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BrownBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(GrizzlyBearAnimation.walk, limbSwing, limbSwingAmount, 3.0f, 2.5f);
                this.animate(entity.animationState1, GrizzlyBearAnimation.claw, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GrizzlyBearAnimation.claw2, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GrizzlyBearAnimation.grab, ageInTicks, 1.0f);
                this.animate(entity.animationState4, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState5, GrizzlyBearAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BrownBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

