/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelPolarBear;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.PolarBearAnimation;
import net.abyssoul.abyssoulswildlife.entity.ColossalPolarBearEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ColossalPolarBearRenderer
extends MobRenderer<ColossalPolarBearEntity, ModelPolarBear<ColossalPolarBearEntity>> {
    public ColossalPolarBearRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelPolarBear.LAYER_LOCATION)), 1.7f);
        this.addLayer((RenderLayer)new RenderLayer<ColossalPolarBearEntity, ModelPolarBear<ColossalPolarBearEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/colossalpolarbear_eye.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ColossalPolarBearEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelPolarBear)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    protected void scale(ColossalPolarBearEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.55f, 1.55f, 1.55f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ColossalPolarBearEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/colossalpolarbear.png");
    }

    private static final class AnimatedModel
    extends ModelPolarBear<ColossalPolarBearEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ColossalPolarBearEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ColossalPolarBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, PolarBearAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState1, PolarBearAnimation.rest, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ColossalPolarBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

