/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelColossalSquid;
import net.abyssoul.abyssoulswildlife.client.model.animations.ColossalSquidAnimation;
import net.abyssoul.abyssoulswildlife.entity.ColossalSquidEntity;
import net.abyssoul.abyssoulswildlife.procedures.ColossalSquidIsFreeProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ColossalSquidRenderer
extends MobRenderer<ColossalSquidEntity, ModelColossalSquid<ColossalSquidEntity>> {
    public ColossalSquidRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelColossalSquid.LAYER_LOCATION)), 1.6f);
    }

    protected void scale(ColossalSquidEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.3f, 1.3f, 1.3f);
    }

    public ResourceLocation getTextureLocation(ColossalSquidEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/colossal_squid.png");
    }

    private static final class AnimatedModel
    extends ModelColossalSquid<ColossalSquidEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ColossalSquidEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ColossalSquidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (ColossalSquidIsFreeProcedure.execute((Entity)entity)) {
                    this.animateWalk(ColossalSquidAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                }
                this.animate(entity.animationState1, ColossalSquidAnimation.grab, ageInTicks, 1.0f);
                this.animate(entity.animationState2, ColossalSquidAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, ColossalSquidAnimation.eye_idle, ageInTicks, 1.0f);
                this.animate(entity.animationState4, ColossalSquidAnimation.bite, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ColossalSquidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

