/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelCondor;
import net.abyssoul.abyssoulswildlife.client.model.animations.CondorAnimation;
import net.abyssoul.abyssoulswildlife.entity.CondorEntity;
import net.abyssoul.abyssoulswildlife.procedures.CondorOnLandProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CondorRenderer
extends MobRenderer<CondorEntity, ModelCondor<CondorEntity>> {
    public CondorRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelCondor.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(CondorEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(CondorEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/condor.png");
    }

    private static final class AnimatedModel
    extends ModelCondor<CondorEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<CondorEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(CondorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, CondorAnimation.stand, ageInTicks, 1.0f);
                if (CondorOnLandProcedure.execute((Entity)entity)) {
                    this.animateWalk(CondorAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                }
                this.animate(entity.animationState2, CondorAnimation.fly, ageInTicks, 1.0f);
                this.animate(entity.animationState3, CondorAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(CondorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

