/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelDumboOctopus;
import net.abyssoul.abyssoulswildlife.client.model.animations.DumboOctopusAnimation;
import net.abyssoul.abyssoulswildlife.entity.DumboOctopusEntity;
import net.abyssoul.abyssoulswildlife.procedures.ShallowWaterProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DumboOctopusRenderer
extends MobRenderer<DumboOctopusEntity, ModelDumboOctopus<DumboOctopusEntity>> {
    public DumboOctopusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelDumboOctopus.LAYER_LOCATION)), 0.2f);
    }

    protected void scale(DumboOctopusEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(DumboOctopusEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/dumbo_octopus.png");
    }

    protected boolean isShaking(DumboOctopusEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return ShallowWaterProcedure.execute((LevelAccessor)world, x, y, z);
    }

    private static final class AnimatedModel
    extends ModelDumboOctopus<DumboOctopusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DumboOctopusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DumboOctopusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(DumboOctopusAnimation.swim1, limbSwing, limbSwingAmount, 2.5f, 3.0f);
                this.animateWalk(DumboOctopusAnimation.swim2, limbSwing, limbSwingAmount, 2.5f, 3.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DumboOctopusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

