/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.Modelelephant;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.elephantAnimation;
import net.abyssoul.abyssoulswildlife.entity.ElephantEntity;
import net.abyssoul.abyssoulswildlife.procedures.ElephantIsAsianProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ElephantRenderer
extends MobRenderer<ElephantEntity, Modelelephant<ElephantEntity>> {
    public ElephantRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelelephant.LAYER_LOCATION)), 2.2f);
        this.addLayer((RenderLayer)new RenderLayer<ElephantEntity, Modelelephant<ElephantEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/elephant_asian.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ElephantEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (ElephantIsAsianProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelelephant)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(ElephantEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.12f, 1.12f, 1.12f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ElephantEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/elephant_african.png");
    }

    private static final class AnimatedModel
    extends Modelelephant<ElephantEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ElephantEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ElephantEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(elephantAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.0f);
                this.animate(entity.animationState1, elephantAnimation.tusk_attack, ageInTicks, 1.0f);
                this.animate(entity.animationState2, elephantAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animateWalk(elephantAnimation.idle, limbSwing, limbSwingAmount, 2.0f, 2.0f);
                this.animate(entity.animationState5, elephantAnimation.stomp, ageInTicks, 1.0f);
                this.animate(entity.animationState6, elephantAnimation.eat, ageInTicks, 1.0f);
                this.animate(entity.animationState7, elephantAnimation.asianvariant, ageInTicks, 1.0f);
                this.animate(entity.animationState8, elephantAnimation.howl, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ElephantEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

