/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelElephantSeal;
import net.abyssoul.abyssoulswildlife.client.model.animations.ElephantSealAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.ElephantSealEntity;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealIsLordProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealSizeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealStandAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealSwimAnimProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ElephantSealRenderer
extends MobRenderer<ElephantSealEntity, ModelElephantSeal<ElephantSealEntity>> {
    public ElephantSealRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelElephantSeal.LAYER_LOCATION)), 2.0f);
        this.addLayer((RenderLayer)new RenderLayer<ElephantSealEntity, ModelElephantSeal<ElephantSealEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/elephant_seal_nose.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ElephantSealEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (ElephantSealIsLordProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelElephantSeal)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(ElephantSealEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)ElephantSealSizeProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ElephantSealEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/elephant_seal.png");
    }

    private static final class AnimatedModel
    extends ModelElephantSeal<ElephantSealEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ElephantSealEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ElephantSealEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, ElephantSealAnimation.stand, ageInTicks, 1.0f);
                if (ElephantSealStandAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(ElephantSealAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                }
                if (ElephantSealSwimAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(ElephantSealAnimation.swim, limbSwing, limbSwingAmount, 2.0f, 1.5f);
                }
                this.animate(entity.animationState3, ElephantSealAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState4, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ElephantSealEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

