/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelGiantGrouper;
import net.abyssoul.abyssoulswildlife.client.model.animations.GiantGrouperAnimation;
import net.abyssoul.abyssoulswildlife.entity.GiantGrouperEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GiantGrouperRenderer
extends MobRenderer<GiantGrouperEntity, ModelGiantGrouper<GiantGrouperEntity>> {
    public GiantGrouperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGiantGrouper.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(GiantGrouperEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.3f, 1.3f, 1.3f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GiantGrouperEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/giant_grouper.png");
    }

    private static final class AnimatedModel
    extends ModelGiantGrouper<GiantGrouperEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GiantGrouperEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GiantGrouperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(GiantGrouperAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, GiantGrouperAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GiantGrouperAnimation.consume, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GiantGrouperAnimation.havefood, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GiantGrouperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

