/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelGoldeneagle;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenEagleAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.GoldenEagleEntity;
import net.abyssoul.abyssoulswildlife.procedures.CondorOnLandProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GoldenEagleRenderer
extends MobRenderer<GoldenEagleEntity, ModelGoldeneagle<GoldenEagleEntity>> {
    public GoldenEagleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGoldeneagle.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(GoldenEagleEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.2f, 1.2f, 1.2f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GoldenEagleEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/golden_eagle.png");
    }

    private static final class AnimatedModel
    extends ModelGoldeneagle<GoldenEagleEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GoldenEagleEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GoldenEagleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, GoldenEagleAnimation.stand, ageInTicks, 1.0f);
                if (CondorOnLandProcedure.execute((Entity)entity)) {
                    this.animateWalk(GoldenEagleAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                }
                this.animate(entity.animationState2, GoldenEagleAnimation.fly, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenEagleAnimation.beak, ageInTicks, 1.0f);
                this.animate(entity.animationState4, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState5, GoldenEagleAnimation.claw, ageInTicks, 1.0f);
                this.animate(entity.animationState6, GoldenEagleAnimation.dash, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GoldenEagleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

