/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelGoldenTakin;
import net.abyssoul.abyssoulswildlife.client.model.animations.AfricanBuffaloAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.entity.GoldenTakinEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GoldenTakinRenderer
extends MobRenderer<GoldenTakinEntity, ModelGoldenTakin<GoldenTakinEntity>> {
    public GoldenTakinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGoldenTakin.LAYER_LOCATION)), 1.2f);
    }

    protected void scale(GoldenTakinEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.25f, 1.25f, 1.25f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GoldenTakinEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/golden_takin.png");
    }

    private static final class AnimatedModel
    extends ModelGoldenTakin<GoldenTakinEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GoldenTakinEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GoldenTakinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(GoldenTakinAnimation.walk, limbSwing, limbSwingAmount, 2.5f, 2.0f);
                this.animate(entity.animationState1, GoldenTakinAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GoldenTakinAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState4, AfricanBuffaloAnimation.isBaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GoldenTakinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

