/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.abyssoul.abyssoulswildlife.client.model.ModelSpermwhaleSonicBoom;
import net.abyssoul.abyssoulswildlife.entity.GreatVortexEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class GreatVortexRenderer
extends EntityRenderer<GreatVortexEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/spermwhale_sonicboom.png");
    private final ModelSpermwhaleSonicBoom model;

    public GreatVortexRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelSpermwhaleSonicBoom(context.bakeLayer(ModelSpermwhaleSonicBoom.LAYER_LOCATION));
    }

    public void render(GreatVortexEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn)));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.tickCount + partialTicks, entityIn.getYRot(), entityIn.getXRot());
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(GreatVortexEntity entity) {
        return texture;
    }
}

