/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelGreatWhite;
import net.abyssoul.abyssoulswildlife.client.model.animations.GreatWhiteAnimation;
import net.abyssoul.abyssoulswildlife.entity.GreatWhiteEntity;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteScaleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteSkin1Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class GreatWhiteRenderer
extends MobRenderer<GreatWhiteEntity, ModelGreatWhite<GreatWhiteEntity>> {
    public GreatWhiteRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGreatWhite.LAYER_LOCATION)), 1.6f);
        this.addLayer((RenderLayer)new RenderLayer<GreatWhiteEntity, ModelGreatWhite<GreatWhiteEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/greatwhite1.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GreatWhiteEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (GreatWhiteSkin1Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelGreatWhite)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(GreatWhiteEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)GreatWhiteScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GreatWhiteEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/greatwhite.png");
    }

    private static final class AnimatedModel
    extends ModelGreatWhite<GreatWhiteEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GreatWhiteEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GreatWhiteEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(GreatWhiteAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, GreatWhiteAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GreatWhiteAnimation.stranded, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GreatWhiteAnimation.charge, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GreatWhiteEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

