/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelHerculodon;
import net.abyssoul.abyssoulswildlife.client.model.animations.HerculodonAnimation;
import net.abyssoul.abyssoulswildlife.entity.HerculodonEntity;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonGlowingConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class HerculodonRenderer
extends MobRenderer<HerculodonEntity, ModelHerculodon<HerculodonEntity>> {
    public HerculodonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelHerculodon.LAYER_LOCATION)), 6.0f);
        this.addLayer((RenderLayer)new RenderLayer<HerculodonEntity, ModelHerculodon<HerculodonEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/herculodon_glowing.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, HerculodonEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (HerculodonGlowingConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelHerculodon)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(HerculodonEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(3.6f, 3.6f, 3.6f);
    }

    public ResourceLocation getTextureLocation(HerculodonEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/herculodon.png");
    }

    private static final class AnimatedModel
    extends ModelHerculodon<HerculodonEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<HerculodonEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(HerculodonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(HerculodonAnimation.swin, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                this.animate(entity.animationState1, HerculodonAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, HerculodonAnimation.rage, ageInTicks, 1.0f);
                this.animate(entity.animationState3, HerculodonAnimation.death, ageInTicks, 1.0f);
                this.animate(entity.animationState4, HerculodonAnimation.suck, ageInTicks, 1.0f);
                this.animate(entity.animationState5, HerculodonAnimation.shortdash, ageInTicks, 1.0f);
                this.animate(entity.animationState6, HerculodonAnimation.charge, ageInTicks, 1.0f);
                this.animate(entity.animationState7, HerculodonAnimation.laser, ageInTicks, 1.0f);
                this.animate(entity.animationState8, HerculodonAnimation.lasernocharge, ageInTicks, 1.0f);
                this.animate(entity.animationState9, HerculodonAnimation.tailswip, ageInTicks, 1.0f);
                this.animate(entity.animationState10, HerculodonAnimation.tailswip2, ageInTicks, 1.0f);
                this.animate(entity.animationState11, HerculodonAnimation.ripapart, ageInTicks, 1.0f);
                this.animate(entity.animationState12, HerculodonAnimation.execution, ageInTicks, 1.0f);
                this.animate(entity.animationState13, HerculodonAnimation.finalkill, ageInTicks, 1.0f);
                this.animate(entity.animationState14, HerculodonAnimation.spit, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(HerculodonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

