/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelHoneyBadger;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.HoneyBadgerAnimation;
import net.abyssoul.abyssoulswildlife.entity.HoneyBadgerEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class HoneyBadgerRenderer
extends MobRenderer<HoneyBadgerEntity, ModelHoneyBadger<HoneyBadgerEntity>> {
    public HoneyBadgerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelHoneyBadger.LAYER_LOCATION)), 0.6f);
    }

    protected void scale(HoneyBadgerEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(HoneyBadgerEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/honey_badger.png");
    }

    private static final class AnimatedModel
    extends ModelHoneyBadger<HoneyBadgerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<HoneyBadgerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(HoneyBadgerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(HoneyBadgerAnimation.move, limbSwing, limbSwingAmount, 5.0f, 1.5f);
                this.animate(entity.animationState1, HoneyBadgerAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, HoneyBadgerAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(HoneyBadgerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

