/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelHumpbackWhale;
import net.abyssoul.abyssoulswildlife.client.model.animations.HumpbackWhaleAnimation;
import net.abyssoul.abyssoulswildlife.entity.HumpbackWhaleEntity;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleHaveBarnacleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleMigalooSkinProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class HumpbackWhaleRenderer
extends MobRenderer<HumpbackWhaleEntity, ModelHumpbackWhale<HumpbackWhaleEntity>> {
    public HumpbackWhaleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelHumpbackWhale.LAYER_LOCATION)), 4.2f);
        this.addLayer((RenderLayer)new RenderLayer<HumpbackWhaleEntity, ModelHumpbackWhale<HumpbackWhaleEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/migaloo.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, HumpbackWhaleEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (HumpbackWhaleMigalooSkinProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelHumpbackWhale)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<HumpbackWhaleEntity, ModelHumpbackWhale<HumpbackWhaleEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/barnacle.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, HumpbackWhaleEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (HumpbackWhaleHaveBarnacleProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelHumpbackWhale)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(HumpbackWhaleEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(3.0f, 3.0f, 3.0f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(HumpbackWhaleEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/humpback_whale.png");
    }

    private static final class AnimatedModel
    extends ModelHumpbackWhale<HumpbackWhaleEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<HumpbackWhaleEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(HumpbackWhaleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(HumpbackWhaleAnimation.swim, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                this.animate(entity.animationState1, HumpbackWhaleAnimation.eat, ageInTicks, 1.0f);
                this.animate(entity.animationState2, HumpbackWhaleAnimation.stranded, ageInTicks, 1.0f);
                this.animate(entity.animationState3, HumpbackWhaleAnimation.punch, ageInTicks, 1.0f);
                this.animate(entity.animationState4, HumpbackWhaleAnimation.tailswipe, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(HumpbackWhaleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

