/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import net.abyssoul.abyssoulswildlife.client.model.ModelIcefish;
import net.abyssoul.abyssoulswildlife.client.model.animations.IcefishAnimation;
import net.abyssoul.abyssoulswildlife.entity.IcefishEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class IcefishRenderer
extends MobRenderer<IcefishEntity, ModelIcefish<IcefishEntity>> {
    public IcefishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelIcefish.LAYER_LOCATION)), 0.2f);
    }

    public ResourceLocation getTextureLocation(IcefishEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/icefish.png");
    }

    private static final class AnimatedModel
    extends ModelIcefish<IcefishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<IcefishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(IcefishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, IcefishAnimation.swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(IcefishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

