/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelJaguar;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.JaguarAnimation;
import net.abyssoul.abyssoulswildlife.entity.JaguarEntity;
import net.abyssoul.abyssoulswildlife.procedures.JaguarRunAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarSkinType1Procedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarWalkAnimProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class JaguarRenderer
extends MobRenderer<JaguarEntity, ModelJaguar<JaguarEntity>> {
    public JaguarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelJaguar.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<JaguarEntity, ModelJaguar<JaguarEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/jaguar_eyes.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, JaguarEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelJaguar)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<JaguarEntity, ModelJaguar<JaguarEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/jaguar_black.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, JaguarEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (JaguarSkinType1Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelJaguar)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(JaguarEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(JaguarEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/jaguar.png");
    }

    private static final class AnimatedModel
    extends ModelJaguar<JaguarEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<JaguarEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(JaguarEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, JaguarAnimation.idle, ageInTicks, 1.0f);
                if (JaguarWalkAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(JaguarAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.3f);
                }
                if (JaguarRunAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(JaguarAnimation.run, limbSwing, limbSwingAmount, 1.5f, 1.3f);
                }
                this.animate(entity.animationState3, JaguarAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState4, JaguarAnimation.claw, ageInTicks, 1.0f);
                this.animate(entity.animationState5, JaguarAnimation.leap, ageInTicks, 1.0f);
                this.animate(entity.animationState6, JaguarAnimation.headcrush, ageInTicks, 1.0f);
                this.animate(entity.animationState7, JaguarAnimation.rest, ageInTicks, 1.0f);
                this.animate(entity.animationState8, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(JaguarEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

