/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.Modelorca;
import net.abyssoul.abyssoulswildlife.client.model.animations.orcaAnimation;
import net.abyssoul.abyssoulswildlife.entity.OrcaEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class OrcaRenderer
extends MobRenderer<OrcaEntity, Modelorca<OrcaEntity>> {
    public OrcaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelorca.LAYER_LOCATION)), 3.5f);
    }

    protected void scale(OrcaEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(OrcaEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/orca.png");
    }

    private static final class AnimatedModel
    extends Modelorca<OrcaEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<OrcaEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(OrcaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(orcaAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                this.animate(entity.animationState1, orcaAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState2, orcaAnimation.charge, ageInTicks, 1.0f);
                this.animate(entity.animationState3, orcaAnimation.tailswipe, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(OrcaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

