/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelReindeer;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.ReindeerAnimation;
import net.abyssoul.abyssoulswildlife.entity.ReindeerEntity;
import net.abyssoul.abyssoulswildlife.procedures.JaguarRunAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarWalkAnimProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ReindeerRenderer
extends MobRenderer<ReindeerEntity, ModelReindeer<ReindeerEntity>> {
    public ReindeerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelReindeer.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(ReindeerEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ReindeerEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/reindeer.png");
    }

    private static final class AnimatedModel
    extends ModelReindeer<ReindeerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ReindeerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ReindeerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, GoldenTakinAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, ReindeerAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState2, ReindeerAnimation.noantler, ageInTicks, 1.0f);
                if (JaguarWalkAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(ReindeerAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.5f);
                }
                if (JaguarRunAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(ReindeerAnimation.run, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ReindeerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

