/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelRhino;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.RhinoAnimation;
import net.abyssoul.abyssoulswildlife.entity.RhinoEntity;
import net.abyssoul.abyssoulswildlife.procedures.RhinoIsIndianProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RhinoRenderer
extends MobRenderer<RhinoEntity, ModelRhino<RhinoEntity>> {
    public RhinoRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelRhino.LAYER_LOCATION)), 2.0f);
        this.addLayer((RenderLayer)new RenderLayer<RhinoEntity, ModelRhino<RhinoEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/rhino_indian.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RhinoEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (RhinoIsIndianProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelRhino)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(RhinoEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.9f, 0.9f, 0.9f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(RhinoEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/rhino_white.png");
    }

    private static final class AnimatedModel
    extends ModelRhino<RhinoEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RhinoEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RhinoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(RhinoAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.0f);
                this.animate(entity.animationState1, RhinoAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState2, RhinoAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState4, RhinoAnimation.attack2, ageInTicks, 1.0f);
                this.animate(entity.animationState5, RhinoAnimation.charge, ageInTicks, 1.0f);
                this.animate(entity.animationState6, RhinoAnimation.indian_variant, ageInTicks, 1.0f);
                this.animate(entity.animationState7, RhinoAnimation.shakehead, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RhinoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

