/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelSailfish;
import net.abyssoul.abyssoulswildlife.client.model.animations.SailfishAnimation;
import net.abyssoul.abyssoulswildlife.entity.SailfishEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SailfishRenderer
extends MobRenderer<SailfishEntity, ModelSailfish<SailfishEntity>> {
    public SailfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSailfish.LAYER_LOCATION)), 1.3f);
    }

    protected void scale(SailfishEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(3.0f, 3.0f, 3.0f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SailfishEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/sailfish.png");
    }

    private static final class AnimatedModel
    extends ModelSailfish<SailfishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SailfishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SailfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(SailfishAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SailfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

