/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelSaltwaterCrocodile;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.SaltwaterCrocodileAnimation;
import net.abyssoul.abyssoulswildlife.entity.SaltwaterCrocodileEntity;
import net.abyssoul.abyssoulswildlife.procedures.CrocodileSizeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealStandAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSealSwimAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileSkintype1Procedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileSkintype2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SaltwaterCrocodileRenderer
extends MobRenderer<SaltwaterCrocodileEntity, ModelSaltwaterCrocodile<SaltwaterCrocodileEntity>> {
    public SaltwaterCrocodileRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSaltwaterCrocodile.LAYER_LOCATION)), 1.1f);
        this.addLayer((RenderLayer)new RenderLayer<SaltwaterCrocodileEntity, ModelSaltwaterCrocodile<SaltwaterCrocodileEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/saltwater_crocodile1.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SaltwaterCrocodileEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SaltwaterCrocodileSkintype1Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelSaltwaterCrocodile)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<SaltwaterCrocodileEntity, ModelSaltwaterCrocodile<SaltwaterCrocodileEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/saltwater_crocodile2.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SaltwaterCrocodileEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SaltwaterCrocodileSkintype2Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelSaltwaterCrocodile)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(SaltwaterCrocodileEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)CrocodileSizeProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SaltwaterCrocodileEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/saltwater_crocodile.png");
    }

    private static final class AnimatedModel
    extends ModelSaltwaterCrocodile<SaltwaterCrocodileEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SaltwaterCrocodileEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SaltwaterCrocodileEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (ElephantSealStandAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(SaltwaterCrocodileAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.8f);
                }
                if (ElephantSealSwimAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(SaltwaterCrocodileAnimation.swim, limbSwing, limbSwingAmount, 2.0f, 1.8f);
                }
                this.animate(entity.animationState2, SaltwaterCrocodileAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState4, SaltwaterCrocodileAnimation.tailswipe, ageInTicks, 1.0f);
                this.animate(entity.animationState5, SaltwaterCrocodileAnimation.deathroll, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SaltwaterCrocodileEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

