/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelSeablueGuardian;
import net.abyssoul.abyssoulswildlife.client.model.animations.SeablueGuardianAnimation;
import net.abyssoul.abyssoulswildlife.entity.SeablueGuardianEntity;
import net.abyssoul.abyssoulswildlife.procedures.SeablueGuardianShakeProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SeablueGuardianRenderer
extends MobRenderer<SeablueGuardianEntity, ModelSeablueGuardian<SeablueGuardianEntity>> {
    public SeablueGuardianRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSeablueGuardian.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<SeablueGuardianEntity, ModelSeablueGuardian<SeablueGuardianEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/seablue_guardian_eye.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SeablueGuardianEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if ((Integer)entity.getEntityData().get(SeablueGuardianEntity.DATA_launchtime) > 10) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelSeablueGuardian)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(SeablueGuardianEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(2.0f, 2.0f, 2.0f);
    }

    public ResourceLocation getTextureLocation(SeablueGuardianEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/seablue_guardian.png");
    }

    protected boolean isShaking(SeablueGuardianEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return SeablueGuardianShakeProcedure.execute((Entity)entity);
    }

    private static final class AnimatedModel
    extends ModelSeablueGuardian<SeablueGuardianEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SeablueGuardianEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SeablueGuardianEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, SeablueGuardianAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, SeablueGuardianAnimation.idle2, ageInTicks, 1.0f);
                this.animateWalk(SeablueGuardianAnimation.swim, limbSwing, limbSwingAmount, 1.5f, 1.5f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SeablueGuardianEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

