/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abyssoul.abyssoulswildlife.client.model.ModelSiberianTiger;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.JaguarAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.SiberianTigerAnimation;
import net.abyssoul.abyssoulswildlife.entity.SiberianTigerEntity;
import net.abyssoul.abyssoulswildlife.procedures.JaguarRunAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarWalkAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SiberianTigerGlowEyeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SiberianTigerRedEyeProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SiberianTigerRenderer
extends MobRenderer<SiberianTigerEntity, ModelSiberianTiger<SiberianTigerEntity>> {
    public SiberianTigerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSiberianTiger.LAYER_LOCATION)), 1.3f);
        this.addLayer((RenderLayer)new RenderLayer<SiberianTigerEntity, ModelSiberianTiger<SiberianTigerEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/siberian_tiger_eye1.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SiberianTigerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SiberianTigerGlowEyeProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelSiberianTiger)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<SiberianTigerEntity, ModelSiberianTiger<SiberianTigerEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/siberian_tiger_eye2.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SiberianTigerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SiberianTigerRedEyeProcedure.execute((LevelAccessor)world, (Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelSiberianTiger)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(SiberianTigerEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SiberianTigerEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/siberian_tiger.png");
    }

    private static final class AnimatedModel
    extends ModelSiberianTiger<SiberianTigerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SiberianTigerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SiberianTigerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, JaguarAnimation.idle, ageInTicks, 1.0f);
                if (JaguarWalkAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(SiberianTigerAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.3f);
                }
                if (JaguarRunAnimProcedure.execute((Entity)entity)) {
                    this.animateWalk(SiberianTigerAnimation.run, limbSwing, limbSwingAmount, 1.5f, 1.3f);
                }
                this.animate(entity.animationState3, SiberianTigerAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState4, SiberianTigerAnimation.claw1, ageInTicks, 1.0f);
                this.animate(entity.animationState5, SiberianTigerAnimation.leap, ageInTicks, 1.0f);
                this.animate(entity.animationState6, SiberianTigerAnimation.claw2, ageInTicks, 1.0f);
                this.animate(entity.animationState7, SiberianTigerAnimation.rest, ageInTicks, 1.0f);
                this.animate(entity.animationState8, SiberianTigerAnimation.dodge, ageInTicks, 1.0f);
                this.animate(entity.animationState9, SiberianTigerAnimation.roar, ageInTicks, 1.0f);
                this.animate(entity.animationState10, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SiberianTigerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

