/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.abyssoul.abyssoulswildlife.client.model.ModelZebra;
import net.abyssoul.abyssoulswildlife.client.model.animations.GoldenTakinAnimation;
import net.abyssoul.abyssoulswildlife.client.model.animations.ZebraAnimation;
import net.abyssoul.abyssoulswildlife.entity.ZebraEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ZebraRenderer
extends MobRenderer<ZebraEntity, ModelZebra<ZebraEntity>> {
    public ZebraRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelZebra.LAYER_LOCATION)), 1.1f);
    }

    protected void scale(ZebraEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ZebraEntity entity) {
        return ResourceLocation.parse((String)"abyssouls_wildlife:textures/entities/zebra.png");
    }

    private static final class AnimatedModel
    extends ModelZebra<ZebraEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ZebraEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ZebraEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(ZebraAnimation.walk, limbSwing, limbSwingAmount, 2.5f, 2.0f);
                this.animate(entity.animationState1, ZebraAnimation.kick, ageInTicks, 1.0f);
                this.animate(entity.animationState2, ZebraAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState3, GoldenTakinAnimation.isbaby, ageInTicks, 1.0f);
                this.animate(entity.animationState4, ZebraAnimation.kick2, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ZebraEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

