/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedFindWater;
import net.abyssoul.abyssoulswildlife.entity.ai.LeaveWaterGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.AfricanBuffaloAttackProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanBuffaloChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanBuffaloFindWaterProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanBuffaloFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanBuffaloLeaveWaterProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BuffaloOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AfricanBuffaloEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(AfricanBuffaloEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(AfricanBuffaloEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_inwaterTime = SynchedEntityData.defineId(AfricanBuffaloEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();

    public AfricanBuffaloEntity(EntityType<AfricanBuffaloEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_inwaterTime, (Object)300);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true, true));
        this.goalSelector.addGoal(5, (Goal)new AdvancedFindWater((PathfinderMob)this){

            @Override
            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFindWaterProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LeaveWaterGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloLeaveWaterProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal(this, 1.0){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal(this, 1.0){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = AfricanBuffaloEntity.this.getX();
                double y = AfricanBuffaloEntity.this.getY();
                double z = AfricanBuffaloEntity.this.getZ();
                AfricanBuffaloEntity entity = AfricanBuffaloEntity.this;
                Level world = AfricanBuffaloEntity.this.level();
                return super.canUse() && AfricanBuffaloFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:buffalo_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:buffalo_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:buffalo_hurt"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DatainwaterTime", ((Integer)this.entityData.get(DATA_inwaterTime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DatainwaterTime")) {
            this.entityData.set(DATA_inwaterTime, (Object)compound.getInt("DatainwaterTime"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(AfricanBuffaloAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(true, this.tickCount);
            this.animationState5.animateWhen(AfricanBuffaloChargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        BuffaloOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        AfricanBuffaloEntity retval = (AfricanBuffaloEntity)((EntityType)AbyssoulsWildlifeModEntities.AFRICAN_BUFFALO.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.WHEAT)}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 55.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

