/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.AfricanBuffaloEntity;
import net.abyssoul.abyssoulswildlife.entity.ZebraEntity;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionClawAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionFollowingOwnerProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionFreeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionLeapAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionParryConditionProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionRestProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionRoarAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionSizeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AfricanLionSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.LionOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.LionParryProcedure;
import net.abyssoul.abyssoulswildlife.procedures.LionRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AfricanLionEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(AfricanLionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(AfricanLionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(AfricanLionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_DodgeCooldown = SynchedEntityData.defineId(AfricanLionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_IsMale = SynchedEntityData.defineId(AfricanLionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();

    public AfricanLionEntity(EntityType<AfricanLionEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_DodgeCooldown, (Object)0);
        builder.define(DATA_IsMale, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ZebraEntity.class, true, true){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AfricanBuffaloEntity.class, true, true){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowOwnerGoal(this, 1.5, 10.0f, 2.0f){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFollowingOwnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AfricanLionEntity.this.getX();
                double y = AfricanLionEntity.this.getY();
                double z = AfricanLionEntity.this.getZ();
                AfricanLionEntity entity = AfricanLionEntity.this;
                Level world = AfricanLionEntity.this.level();
                return super.canUse() && AfricanLionFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:lion_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:lion_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:lion_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AfricanLionEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (!LionParryProcedure.execute((LevelAccessor)world, x, y, z, damagesource, (Entity)entity)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AfricanLionSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("DataDodgeCooldown", ((Integer)this.entityData.get(DATA_DodgeCooldown)).intValue());
        compound.putInt("DataIsMale", ((Integer)this.entityData.get(DATA_IsMale)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("DataDodgeCooldown")) {
            this.entityData.set(DATA_DodgeCooldown, (Object)compound.getInt("DataDodgeCooldown"));
        }
        if (compound.contains("DataIsMale")) {
            this.entityData.set(DATA_IsMale, (Object)compound.getInt("DataIsMale"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        AfricanLionEntity entity = this;
                        Level world = this.level();
                        return LionRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(AfricanLionBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(AfricanLionClawAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(AfricanLionLeapAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(AfricanLionRestProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(AfricanLionParryConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(AfricanLionRoarAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        LionOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        if (this.getEntityData().get(DATA_IsMale) != ageable.getEntityData().get(DATA_IsMale) || ageable == this) {
            AfricanLionEntity retval = (AfricanLionEntity)((EntityType)AbyssoulsWildlifeModEntities.AFRICAN_LION.get()).create((Level)serverWorld);
            retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
            return retval;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.LARGE_BEAST_BONE.get())}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        AfricanLionEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)AfricanLionSizeProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 35.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(Attributes.SAFE_FALL_DISTANCE, 6.0);
        return builder;
    }
}

