/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.BossEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedHurtByTargetGoal;
import net.abyssoul.abyssoulswildlife.entity.ai.CustomPathNavigateGround;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModBlocks;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModParticleTypes;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenBurnedAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenClaw11AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenClaw1AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenClaw2AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenFinalkillAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenHugAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenQuickClawAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenRoarAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenSummonAnimalAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenSummonCrowAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenSummonThornAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AncientLeshenTeleportAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.DeathProcedure;
import net.abyssoul.abyssoulswildlife.server.CustomServerBossEvent;
import net.abyssoul.abyssoulswildlife.server.MessageMusic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;

public class AncientLeshenEntity
extends BossEntity {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_tickSinceCombat = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_finalkillCooldown = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Phase = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homex = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homey = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homez = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_summonthornCooldown = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_summoncrowCooldown = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_summonAnimalCooldown = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_CanbeburnedCount = SynchedEntityData.defineId(AncientLeshenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    public final AnimationState animationState10 = new AnimationState();
    public final AnimationState animationState11 = new AnimationState();
    public final AnimationState animationState12 = new AnimationState();
    public final AnimationState animationState13 = new AnimationState();
    public final AnimationState animationState14 = new AnimationState();
    public int bossDeathTime = 0;
    private int destroyBlocksTick;
    private final CustomServerBossEvent bossInfo = new CustomServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, false, 0);

    public AncientLeshenEntity(EntityType<AncientLeshenEntity> type, Level world) {
        super(type, world);
        this.xpReward = 500;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean canDisableShield() {
        return !AncientLeshenQuickClawAnimProcedure.execute((Entity)this) && !AncientLeshenRoarAnimProcedure.execute((Entity)this);
    }

    protected float getSoundVolume() {
        return 3.0f;
    }

    protected boolean canRide(Entity p_31169_) {
        return false;
    }

    public boolean canUsePortal(boolean p_352948_) {
        return false;
    }

    public boolean IsTeleporting() {
        return AncientLeshenTeleportAnimProcedure.execute((Entity)this) && this.TeleportingProgress() > 70;
    }

    public int TeleportingProgress() {
        return (Integer)this.entityData.get(DATA_ActionTime);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_tickSinceCombat, (Object)200);
        builder.define(DATA_finalkillCooldown, (Object)0);
        builder.define(DATA_Phase, (Object)0);
        builder.define(DATA_homex, (Object)0);
        builder.define(DATA_homey, (Object)-200);
        builder.define(DATA_homez, (Object)0);
        builder.define(DATA_summonthornCooldown, (Object)0);
        builder.define(DATA_summoncrowCooldown, (Object)0);
        builder.define(DATA_summonAnimalCooldown, (Object)0);
        builder.define(DATA_CanbeburnedCount, (Object)3);
    }

    protected PathNavigation createNavigation(Level world) {
        return new CustomPathNavigateGround((Mob)this, world);
    }

    protected void tickDeath() {
        Level level;
        ++this.bossDeathTime;
        if (this.bossDeathTime == 1 && this.level() instanceof ServerLevel) {
            this.level().setBlock(BlockPos.containing((double)((double)((Integer)this.entityData.get(DATA_homex)).intValue() + 0.5), (double)((Integer)this.entityData.get(DATA_homey)).intValue(), (double)((double)((Integer)this.entityData.get(DATA_homez)).intValue() + 0.5)), ((Block)AbyssoulsWildlifeModBlocks.LESHEN_ALTAR.get()).defaultBlockState(), 3);
            level = this.level();
            if (level instanceof Level) {
                Level _level = level;
                _level.updateNeighborsAt(BlockPos.containing((double)((double)((Integer)this.entityData.get(DATA_homex)).intValue() + 0.5), (double)((Integer)this.entityData.get(DATA_homey)).intValue(), (double)((double)((Integer)this.entityData.get(DATA_homez)).intValue() + 0.5)), _level.getBlockState(BlockPos.containing((double)((double)((Integer)this.entityData.get(DATA_homex)).intValue() - 0.5), (double)((Integer)this.entityData.get(DATA_homey)).intValue(), (double)((double)((Integer)this.entityData.get(DATA_homez)).intValue() - 0.5))).getBlock());
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            if (this.bossDeathTime <= 50) {
                svlevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 3.0, this.getZ(), this.bossDeathTime, 0.0, 0.0, 0.0, 0.3);
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)AbyssoulsWildlifeModParticleTypes.CROW_PARTICLE.get()), this.getX(), this.getY() + 3.0, this.getZ(), (int)((double)this.bossDeathTime * 0.5), 0.0, 0.0, 0.0, 0.3);
            }
        }
        if (this.bossDeathTime >= 120 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new AdvancedHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AncientLeshenEntity.this.getX();
                double y = AncientLeshenEntity.this.getY();
                double z = AncientLeshenEntity.this.getZ();
                AncientLeshenEntity entity = AncientLeshenEntity.this;
                Level world = AncientLeshenEntity.this.level();
                return super.canUse() && AncientLeshenFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = AncientLeshenEntity.this.getX();
                double y = AncientLeshenEntity.this.getY();
                double z = AncientLeshenEntity.this.getZ();
                AncientLeshenEntity entity = AncientLeshenEntity.this;
                Level world = AncientLeshenEntity.this.level();
                return super.canUse() && AncientLeshenFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean canUse() {
                double x = AncientLeshenEntity.this.getX();
                double y = AncientLeshenEntity.this.getY();
                double z = AncientLeshenEntity.this.getZ();
                AncientLeshenEntity entity = AncientLeshenEntity.this;
                Level world = AncientLeshenEntity.this.level();
                return super.canUse() && AncientLeshenFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = AncientLeshenEntity.this.getX();
                double y = AncientLeshenEntity.this.getY();
                double z = AncientLeshenEntity.this.getZ();
                AncientLeshenEntity entity = AncientLeshenEntity.this;
                Level world = AncientLeshenEntity.this.level();
                return super.canUse() && AncientLeshenFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AncientLeshenEntity.this.getX();
                double y = AncientLeshenEntity.this.getY();
                double z = AncientLeshenEntity.this.getZ();
                AncientLeshenEntity entity = AncientLeshenEntity.this;
                Level world = AncientLeshenEntity.this.level();
                return super.canUse() && AncientLeshenFreeStateProcedure.execute((Entity)entity) && entity.isAlive();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:ancient_leshen_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:ancient_leshen_death"));
    }

    @Override
    protected boolean canPlayMusic() {
        return true;
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:ancient_leshen_bossmusic"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        amount *= 0.6f;
        if (damagesource.is(DamageTypes.ON_FIRE) && (Integer)this.entityData.get(DATA_CanbeburnedCount) > 0) {
            amount *= 16.0f;
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AncientLeshenEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("DatatickSinceCombat", ((Integer)this.entityData.get(DATA_tickSinceCombat)).intValue());
        compound.putInt("DatafinalkillCooldown", ((Integer)this.entityData.get(DATA_finalkillCooldown)).intValue());
        compound.putInt("DataPhase", ((Integer)this.entityData.get(DATA_Phase)).intValue());
        compound.putInt("Datahomex", ((Integer)this.entityData.get(DATA_homex)).intValue());
        compound.putInt("Datahomey", ((Integer)this.entityData.get(DATA_homey)).intValue());
        compound.putInt("Datahomez", ((Integer)this.entityData.get(DATA_homez)).intValue());
        compound.putInt("DatasummonthornCooldown", ((Integer)this.entityData.get(DATA_summonthornCooldown)).intValue());
        compound.putInt("DatasummoncrowCooldown", ((Integer)this.entityData.get(DATA_summoncrowCooldown)).intValue());
        compound.putInt("DatasummonAnimalCooldown", ((Integer)this.entityData.get(DATA_summonAnimalCooldown)).intValue());
        compound.putInt("DataCanbeburnedCount", ((Integer)this.entityData.get(DATA_CanbeburnedCount)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DatatickSinceCombat")) {
            this.entityData.set(DATA_tickSinceCombat, (Object)compound.getInt("DatatickSinceCombat"));
        }
        if (compound.contains("DatafinalkillCooldown")) {
            this.entityData.set(DATA_finalkillCooldown, (Object)compound.getInt("DatafinalkillCooldown"));
        }
        if (compound.contains("DataPhase")) {
            this.entityData.set(DATA_Phase, (Object)compound.getInt("DataPhase"));
        }
        if (compound.contains("Datahomex")) {
            this.entityData.set(DATA_homex, (Object)compound.getInt("Datahomex"));
        }
        if (compound.contains("Datahomey")) {
            this.entityData.set(DATA_homey, (Object)compound.getInt("Datahomey"));
        }
        if (compound.contains("Datahomez")) {
            this.entityData.set(DATA_homez, (Object)compound.getInt("Datahomez"));
        }
        if (compound.contains("DatasummonthornCooldown")) {
            this.entityData.set(DATA_summonthornCooldown, (Object)compound.getInt("DatasummonthornCooldown"));
        }
        if (compound.contains("DatasummoncrowCooldown")) {
            this.entityData.set(DATA_summoncrowCooldown, (Object)compound.getInt("DatasummoncrowCooldown"));
        }
        if (compound.contains("DatasummonAnimalCooldown")) {
            this.entityData.set(DATA_summonAnimalCooldown, (Object)compound.getInt("DatasummonAnimalCooldown"));
        }
        if (compound.contains("DataCanbeburnedCount")) {
            this.entityData.set(DATA_CanbeburnedCount, (Object)compound.getInt("DataCanbeburnedCount"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(AncientLeshenClaw1AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(AncientLeshenClaw11AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(AncientLeshenClaw2AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(AncientLeshenHugAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(AncientLeshenQuickClawAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(true, this.tickCount);
            this.animationState7.animateWhen(AncientLeshenSummonThornAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(AncientLeshenSummonCrowAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(AncientLeshenTeleportAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState10.animateWhen(AncientLeshenRoarAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState11.animateWhen(AncientLeshenSummonAnimalAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState12.animateWhen(AncientLeshenBurnedAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState13.animateWhen(AncientLeshenFinalkillAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState14.animateWhen(DeathProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        AncientLeshenOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.getBossMusic() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessageMusic(this.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
                boolean flag = false;
                int l = Mth.floor((float)(this.getBbWidth() / 2.0f + 1.0f));
                int i1 = Mth.floor((float)this.getBbHeight());
                for (BlockPos blockpos : BlockPos.betweenClosed((int)(this.getBlockX() - l), (int)this.getBlockY(), (int)(this.getBlockZ() - l), (int)(this.getBlockX() + l), (int)(this.getBlockY() + i1), (int)(this.getBlockZ() + l))) {
                    BlockState blockstate = this.level().getBlockState(blockpos);
                    if (!blockstate.canEntityDestroy((BlockGetter)this.level(), blockpos, (Entity)this) || blockstate.is(BlockTags.WITHER_IMMUNE) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                    flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
                }
                if (flag) {
                    this.level().levelEvent(null, 1022, this.blockPosition(), 0);
                }
            }
        }
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 480.0);
        builder = builder.add(Attributes.ARMOR, 14.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 22.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 80.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        return builder;
    }
}

