/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ColossalSquidEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.SwimDeepGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.AntarcticSleeperSharkBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteStrandedAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkIshungryProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkOntickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkScaleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SleeperSharkSpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class AntarcticSleeperSharkEntity
extends Animal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(AntarcticSleeperSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(AntarcticSleeperSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hunger = SynchedEntityData.defineId(AntarcticSleeperSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Scale = SynchedEntityData.defineId(AntarcticSleeperSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_lastattacktime = SynchedEntityData.defineId(AntarcticSleeperSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public AntarcticSleeperSharkEntity(EntityType<AntarcticSleeperSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (AntarcticSleeperSharkEntity.this.isInWater()) {
                    AntarcticSleeperSharkEntity.this.setDeltaMovement(AntarcticSleeperSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !AntarcticSleeperSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - AntarcticSleeperSharkEntity.this.getX();
                    double dy = this.wantedY - AntarcticSleeperSharkEntity.this.getY();
                    double dz = this.wantedZ - AntarcticSleeperSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * AntarcticSleeperSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    AntarcticSleeperSharkEntity.this.setYRot(this.rotlerp(AntarcticSleeperSharkEntity.this.getYRot(), f, 10.0f));
                    AntarcticSleeperSharkEntity.this.yBodyRot = AntarcticSleeperSharkEntity.this.getYRot();
                    AntarcticSleeperSharkEntity.this.yHeadRot = AntarcticSleeperSharkEntity.this.getYRot();
                    if (AntarcticSleeperSharkEntity.this.isInWater()) {
                        AntarcticSleeperSharkEntity.this.setSpeed((float)AntarcticSleeperSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        AntarcticSleeperSharkEntity.this.setXRot(this.rotlerp(AntarcticSleeperSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(AntarcticSleeperSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        AntarcticSleeperSharkEntity.this.setZza(f3 * f1);
                        AntarcticSleeperSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        AntarcticSleeperSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    AntarcticSleeperSharkEntity.this.setSpeed(0.0f);
                    AntarcticSleeperSharkEntity.this.setYya(0.0f);
                    AntarcticSleeperSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_hunger, (Object)20);
        builder.define(DATA_Scale, (Object)1);
        builder.define(DATA_lastattacktime, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ColossalSquidEntity.class, true, true){

            public boolean canUse() {
                double x = AntarcticSleeperSharkEntity.this.getX();
                double y = AntarcticSleeperSharkEntity.this.getY();
                double z = AntarcticSleeperSharkEntity.this.getZ();
                AntarcticSleeperSharkEntity entity = AntarcticSleeperSharkEntity.this;
                Level world = AntarcticSleeperSharkEntity.this.level();
                return super.canUse() && SleeperSharkIshungryProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true, true){

            public boolean canUse() {
                double x = AntarcticSleeperSharkEntity.this.getX();
                double y = AntarcticSleeperSharkEntity.this.getY();
                double z = AntarcticSleeperSharkEntity.this.getZ();
                AntarcticSleeperSharkEntity entity = AntarcticSleeperSharkEntity.this;
                Level world = AntarcticSleeperSharkEntity.this.level();
                return super.canUse() && SleeperSharkIshungryProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssoulsWildlifeModItems.COLOSSAL_SQUID_TENTACLE.get()}), false));
        this.goalSelector.addGoal(7, (Goal)new SwimDeepGoal((PathfinderMob)this, 0.6, 20));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        SleeperSharkSpawnProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("Datahunger", ((Integer)this.entityData.get(DATA_hunger)).intValue());
        compound.putInt("DataScale", ((Integer)this.entityData.get(DATA_Scale)).intValue());
        compound.putInt("Datalastattacktime", ((Integer)this.entityData.get(DATA_lastattacktime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("Datahunger")) {
            this.entityData.set(DATA_hunger, (Object)compound.getInt("Datahunger"));
        }
        if (compound.contains("DataScale")) {
            this.entityData.set(DATA_Scale, (Object)compound.getInt("DataScale"));
        }
        if (compound.contains("Datalastattacktime")) {
            this.entityData.set(DATA_lastattacktime, (Object)compound.getInt("Datalastattacktime"));
        }
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        SleeperSharkKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(AntarcticSleeperSharkBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GreatWhiteStrandedAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SleeperSharkOntickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        AntarcticSleeperSharkEntity retval = (AntarcticSleeperSharkEntity)((EntityType)AbyssoulsWildlifeModEntities.ANTARCTIC_SLEEPER_SHARK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.COLOSSAL_SQUID_TENTACLE.get())}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AntarcticSleeperSharkEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AntarcticSleeperSharkEntity entity = this;
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        AntarcticSleeperSharkEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)SleeperSharkScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.9);
        builder = builder.add(Attributes.MAX_HEALTH, 55.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.7);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.9);
        return builder;
    }
}

