/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.AsiaticBlackBearClaw2Procedure;
import net.abyssoul.abyssoulswildlife.procedures.AsiaticBlackBearClaw3AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AsiaticBlackBearClawAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AsiaticBlackBearHurtProcedure;
import net.abyssoul.abyssoulswildlife.procedures.AsiaticBlackBearIsFreeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BlackBearOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AsiaticBlackBearEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(AsiaticBlackBearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(AsiaticBlackBearEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_HelpPlayerTime = SynchedEntityData.defineId(AsiaticBlackBearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public AsiaticBlackBearEntity(EntityType<AsiaticBlackBearEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_HelpPlayerTime, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.5, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal(this, 1.0){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && AsiaticBlackBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal(this, 1.0){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && AsiaticBlackBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && AsiaticBlackBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && AsiaticBlackBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AsiaticBlackBearEntity.this.getX();
                double y = AsiaticBlackBearEntity.this.getY();
                double z = AsiaticBlackBearEntity.this.getZ();
                AsiaticBlackBearEntity entity = AsiaticBlackBearEntity.this;
                Level world = AsiaticBlackBearEntity.this.level();
                return super.canUse() && AsiaticBlackBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:asiaticblackbear_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:asiaticblackbear_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:asiaticblackbear_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AsiaticBlackBearEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        AsiaticBlackBearHurtProcedure.execute((Entity)entity, sourceentity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataHelpPlayerTime", ((Integer)this.entityData.get(DATA_HelpPlayerTime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataHelpPlayerTime")) {
            this.entityData.set(DATA_HelpPlayerTime, (Object)compound.getInt("DataHelpPlayerTime"));
        }
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(AsiaticBlackBearClawAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(AsiaticBlackBearClaw2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(AsiaticBlackBearClaw3AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        BlackBearOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        AsiaticBlackBearEntity retval = (AsiaticBlackBearEntity)((EntityType)AbyssoulsWildlifeModEntities.ASIATIC_BLACK_BEAR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:foods"))).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 40.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 4.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

