/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.AsiaticBlackBearEntity;
import net.abyssoul.abyssoulswildlife.entity.ReindeerEntity;
import net.abyssoul.abyssoulswildlife.entity.WildboarEntity;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearClaw2AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearClawAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearGrabAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearIsFreeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.BrownBearRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;

public class BrownBearEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(BrownBearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(BrownBearEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    private final ItemStackHandler inventory = new ItemStackHandler(12);
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public BrownBearEntity(EntityType<BrownBearEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.6, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ReindeerEntity.class, 200, true, true, p_28879_ -> {
            TamableAnimal tamable;
            return p_28879_ instanceof TamableAnimal && !(tamable = (TamableAnimal)p_28879_).isTame();
        }));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, WildboarEntity.class, 200, true, true, p_28879_ -> {
            TamableAnimal tamable;
            return p_28879_ instanceof TamableAnimal && !(tamable = (TamableAnimal)p_28879_).isTame();
        }));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AsiaticBlackBearEntity.class, 600, true, true, p_28879_ -> p_28879_ instanceof LivingEntity));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal(this, 1.0){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal(this, 1.0){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = BrownBearEntity.this.getX();
                double y = BrownBearEntity.this.getY();
                double z = BrownBearEntity.this.getZ();
                BrownBearEntity entity = BrownBearEntity.this;
                Level world = BrownBearEntity.this.level();
                return super.canUse() && BrownBearIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:brown_bear_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:brown_bear_ambient"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:brown_bear_death"));
    }

    public CombinedInvWrapper getCombinedInventory() {
        return this.combined;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.put("InventoryCustom", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        Tag tag;
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if ((tag = compound.get("InventoryCustom")) instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)tag;
            this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), inventoryTag);
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.PASS;
        super.mobInteract(sourceentity, hand);
        if (!this.isBaby() && retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            BrownBearEntity entity = this;
            Level world = this.level();
            BrownBearRightClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(BrownBearClawAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(BrownBearClaw2AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(BrownBearGrabAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(BrownBearBiteAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        BrownBearOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        BrownBearEntity retval = (BrownBearEntity)((EntityType)AbyssoulsWildlifeModEntities.BROWN_BEAR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:null"))).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 8.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

