/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.ai.CustomPathNavigateGround;
import net.abyssoul.abyssoulswildlife.entity.ai.LeaveWaterGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearAttackAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearIsFollowingOwnerProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearRestProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ColossalPolarBearRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.NeedOxygenProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ColossalPolarBearEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(ColossalPolarBearEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(ColossalPolarBearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(ColossalPolarBearEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    private boolean isLandNavigator;
    private int swimTimer = 0;

    public ColossalPolarBearEntity(EntityType<ColossalPolarBearEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.switchNavigator(false);
        this.setPersistenceRequired();
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            PathNavigation prevNav = this.navigation;
            this.navigation = new CustomPathNavigateGround((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 12, 10, 1.0f, 2.0f, false);
            PathNavigation prevNav = this.navigation;
            this.navigation = new WaterBoundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_FollowState, (Object)"free");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new LeaveWaterGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                return super.canUse() && ColossalPolarBearEntity.this.swimTimer > 1200 && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(5, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearIsFollowingOwnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && ColossalPolarBearFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = ColossalPolarBearEntity.this.getX();
                double y = ColossalPolarBearEntity.this.getY();
                double z = ColossalPolarBearEntity.this.getZ();
                ColossalPolarBearEntity entity = ColossalPolarBearEntity.this;
                Level world = ColossalPolarBearEntity.this.level();
                return super.canUse() && NeedOxygenProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.polar_bear.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.polar_bear.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.polar_bear.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.polar_bear.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        ColossalPolarBearEntity entity = this;
                        Level world = this.level();
                        return ColossalPolarBearRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        boolean ground;
        super.tick();
        boolean bl = ground = !this.isInWater();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (!this.level().isClientSide) {
            this.swimTimer = this.isInWater() ? ++this.swimTimer : --this.swimTimer;
        }
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(ColossalPolarBearAttackAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(ColossalPolarBearRestProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        ColossalPolarBearOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        ColossalPolarBearEntity retval = (ColossalPolarBearEntity)((EntityType)AbyssoulsWildlifeModEntities.COLOSSAL_POLAR_BEAR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.GIANT_PINNIPED_MEAT.get())}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 60.0);
        builder = builder.add(Attributes.ARMOR, 8.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.7);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.5);
        return builder;
    }
}

