/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nonnull;
import net.abyssoul.abyssoulswildlife.entity.ai.SwimDeepGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.DumboOctopusOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class DumboOctopusEntity
extends Animal
implements Bucketable {
    public static final EntityDataAccessor<Integer> DATA_inShallowWaterTime = SynchedEntityData.defineId(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DumboOctopusEntity(EntityType<DumboOctopusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (DumboOctopusEntity.this.isInWater()) {
                    DumboOctopusEntity.this.setDeltaMovement(DumboOctopusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !DumboOctopusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - DumboOctopusEntity.this.getX();
                    double dy = this.wantedY - DumboOctopusEntity.this.getY();
                    double dz = this.wantedZ - DumboOctopusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * DumboOctopusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    DumboOctopusEntity.this.setYRot(this.rotlerp(DumboOctopusEntity.this.getYRot(), f, 10.0f));
                    DumboOctopusEntity.this.yBodyRot = DumboOctopusEntity.this.getYRot();
                    DumboOctopusEntity.this.yHeadRot = DumboOctopusEntity.this.getYRot();
                    if (DumboOctopusEntity.this.isInWater()) {
                        DumboOctopusEntity.this.setSpeed((float)DumboOctopusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        DumboOctopusEntity.this.setXRot(this.rotlerp(DumboOctopusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(DumboOctopusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        DumboOctopusEntity.this.setZza(f3 * f1);
                        DumboOctopusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        DumboOctopusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    DumboOctopusEntity.this.setSpeed(0.0f);
                    DumboOctopusEntity.this.setYya(0.0f);
                    DumboOctopusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)AbyssoulsWildlifeModItems.DUMBO_OCTOPUS_BUCKET.get());
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean bucketed) {
        this.entityData.set(FROM_BUCKET, (Object)bucketed);
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    @Nonnull
    public InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compound);
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_inShallowWaterTime, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public boolean canUse() {
                double x = DumboOctopusEntity.this.getX();
                double y = DumboOctopusEntity.this.getY();
                double z = DumboOctopusEntity.this.getZ();
                DumboOctopusEntity entity = DumboOctopusEntity.this;
                Level world = DumboOctopusEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.3));
        this.goalSelector.addGoal(6, (Goal)new SwimDeepGoal((PathfinderMob)this, 0.6, 20));
    }

    public boolean removeWhenFarAway(double p_27492_) {
        return !this.fromBucket() && !this.hasCustomName() && p_27492_ > 6400.0;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.squid.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.squid.hurt"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DatainShallowWaterTime", ((Integer)this.entityData.get(DATA_inShallowWaterTime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DatainShallowWaterTime")) {
            this.entityData.set(DATA_inShallowWaterTime, (Object)compound.getInt("DatainShallowWaterTime"));
        }
    }

    public void baseTick() {
        super.baseTick();
        DumboOctopusOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        DumboOctopusEntity retval = (DumboOctopusEntity)((EntityType)AbyssoulsWildlifeModEntities.DUMBO_OCTOPUS.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:fishes"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DumboOctopusEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DumboOctopusEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.6);
        builder = builder.add(Attributes.MAX_HEALTH, 4.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.6);
        return builder;
    }
}

