/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ai.CustomPathNavigateGround;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.ElephantEatAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantFollowStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantHowlAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantIsAsianProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantStompAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ElephantTuskAttackProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ElephantEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_IsAsian = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();

    public ElephantEntity(EntityType<ElephantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_IsAsian, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new CustomPathNavigateGround((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal(this, 1.5, 10.0f, 2.0f){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFollowStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0){

            @Override
            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = ElephantEntity.this.getX();
                double y = ElephantEntity.this.getY();
                double z = ElephantEntity.this.getZ();
                ElephantEntity entity = ElephantEntity.this;
                Level world = ElephantEntity.this.level();
                return super.canUse() && ElephantFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:elephant_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:elephant_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:elephant_death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        if (reason != MobSpawnType.BREEDING) {
            ElephantSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        }
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("DataIsAsian", ((Integer)this.entityData.get(DATA_IsAsian)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("DataIsAsian")) {
            this.entityData.set(DATA_IsAsian, (Object)compound.getInt("DataIsAsian"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        if (!this.isBaby()) {
                            sourceentity.startRiding((Entity)this);
                        }
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        ElephantEntity entity = this;
                        Level world = this.level();
                        return ElephantRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack) && ((Integer)this.getEntityData().get(DATA_IsAsian) == 1 || this.isBaby())) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(48) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(ElephantTuskAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(ElephantStompAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(ElephantEatAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(ElephantIsAsianProcedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(ElephantHowlAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        ElephantOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        if (this.getEntityData().get(DATA_IsAsian) == ageable.getEntityData().get(DATA_IsAsian) || ageable == null) {
            ElephantEntity retval = (ElephantEntity)((EntityType)AbyssoulsWildlifeModEntities.ELEPHANT.get()).create((Level)serverWorld);
            retval.getEntityData().set(DATA_IsAsian, (Object)((Integer)this.getEntityData().get(DATA_IsAsian)));
            retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
            return retval;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:leaves"))).test(stack);
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            return;
        }
        super.travel(dir);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 160.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 20.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }

    static class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
        protected final Animal animal;
        private final Class<? extends Animal> partnerClass;
        protected final Level level;
        @Nullable
        protected Animal partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(Animal p_25122_, double p_25123_) {
            this(p_25122_, p_25123_, p_25122_.getClass());
        }

        public BreedGoal(Animal p_25125_, double p_25126_, Class<? extends Animal> p_25127_) {
            this.animal = p_25125_;
            this.level = p_25125_.level();
            this.partnerClass = p_25127_;
            this.speedModifier = p_25126_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.animal.isInLove()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean canContinueToUse() {
            return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60 && !this.partner.isPanicking();
        }

        public void stop() {
            this.partner = null;
            this.loveTime = 0;
        }

        public void tick() {
            this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
            this.animal.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
            ++this.loveTime;
            if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr((Entity)this.partner) < 16.0) {
                this.breed();
            }
        }

        @Nullable
        private Animal getFreePartner() {
            List list = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(8.0));
            double d0 = Double.MAX_VALUE;
            Animal animal = null;
            for (Animal animal1 : list) {
                if (!this.animal.canMate(animal1) || animal1.isPanicking() || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
                animal = animal1;
                d0 = this.animal.distanceToSqr((Entity)animal1);
            }
            return animal;
        }

        protected void breed() {
            this.animal.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
        }
    }
}

