/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ai.PorpoiseAIJump;
import net.abyssoul.abyssoulswildlife.entity.ai.SwimmerJumpPathNavigator;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModMobEffects;
import net.abyssoul.abyssoulswildlife.procedures.FinlessPorpoiseSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class FinlessPorpoiseEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_skintype = SynchedEntityData.defineId(FinlessPorpoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MOISTNESS = SynchedEntityData.defineId(FinlessPorpoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.forNonCombat().range(24.0).ignoreLineOfSight();
    public int jumpCooldown;

    public FinlessPorpoiseEntity(EntityType<FinlessPorpoiseEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveHelperController(this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public int getMoistness() {
        return (Integer)this.entityData.get(MOISTNESS);
    }

    public void setMoistness(int m) {
        this.entityData.set(MOISTNESS, (Object)m);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)2400);
        builder.define(DATA_skintype, (Object)0);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.007, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected PathNavigation createNavigation(Level world) {
        return new SwimmerJumpPathNavigator((Mob)this, world);
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = FinlessPorpoiseEntity.this.getX();
                double y = FinlessPorpoiseEntity.this.getY();
                double z = FinlessPorpoiseEntity.this.getZ();
                FinlessPorpoiseEntity entity = FinlessPorpoiseEntity.this;
                Level world = FinlessPorpoiseEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new SwimWithPlayerGoal(this, 1.3));
        this.goalSelector.addGoal(4, (Goal)new PorpoiseAIJump(this, 10));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.3));
        this.goalSelector.addGoal(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    public int getMaxAirSupply() {
        return 1200;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    protected void updateAir(int m) {
    }

    public void tick() {
        super.tick();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
            float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
            this.setXRot(f2);
        }
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
        } else {
            if (this.isInWaterRainOrBubble()) {
                this.setMoistness(2400);
            } else {
                this.setMoistness(this.getMoistness() - 1);
                if (this.getMoistness() <= 0) {
                    this.hurt(this.damageSources().dryOut(), 1.0f);
                }
                if (this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
                    this.setYRot(this.random.nextFloat() * 360.0f);
                    this.setOnGround(false);
                    this.hasImpulse = true;
                }
            }
            if (this.level().isClientSide && this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.03) {
                Vec3 vector3d = this.getViewVector(0.0f);
                float yRotRad = this.getYRot() * ((float)Math.PI / 180);
                float f = Mth.cos((float)yRotRad) * 0.6f;
                float f1 = Mth.sin((float)yRotRad) * 0.6f;
                float f2 = 0.8f - this.random.nextFloat() * 0.5f;
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:finless_porpoise_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:finless_porpoise_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:finless_porpoise_death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataskintype", ((Integer)this.entityData.get(DATA_skintype)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataskintype")) {
            this.entityData.set(DATA_skintype, (Object)compound.getInt("Dataskintype"));
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        FinlessPorpoiseEntity retval = (FinlessPorpoiseEntity)((EntityType)AbyssoulsWildlifeModEntities.FINLESS_PORPOISE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.setAirSupply(this.getMaxAirSupply());
        this.setMoistness(2400);
        FinlessPorpoiseSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.updateAir(i);
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:fishes"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return true;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        FinlessPorpoiseEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.2);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.2);
        return builder;
    }

    static class MoveHelperController
    extends MoveControl {
        private final FinlessPorpoiseEntity dolphin;

        public MoveHelperController(FinlessPorpoiseEntity dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void tick() {
            if (this.dolphin.isInWater()) {
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.dolphin.getNavigation().isDone()) {
                double d2;
                double d1;
                double d0 = this.wantedX - this.dolphin.getX();
                double d3 = d0 * d0 + (d1 = this.wantedY - this.dolphin.getY()) * d1 + (d2 = this.wantedZ - this.dolphin.getZ()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.setYRot(this.rotlerp(this.dolphin.getYRot(), f, 8.0f));
                    this.dolphin.yBodyRot = this.dolphin.getYRot() + 0.5f;
                    this.dolphin.yHeadRot = this.dolphin.getYRot();
                    float f1 = (float)(this.speedModifier * this.dolphin.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    if (this.dolphin.isInWater()) {
                        this.dolphin.setSpeed(f1 * 0.02f);
                        float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.setXRot(this.rotlerp(this.dolphin.getXRot(), f2, 10.0f));
                        float xRotRad = this.dolphin.getXRot() * ((float)Math.PI / 180);
                        float f3 = Mth.cos((float)xRotRad);
                        float f4 = Mth.sin((float)xRotRad);
                        this.dolphin.zza = f3 * f1;
                        this.dolphin.yya = -f4 * f1;
                    } else {
                        this.dolphin.setSpeed(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.setSpeed(0.0f);
                this.dolphin.setXxa(0.0f);
                this.dolphin.setYya(0.0f);
                this.dolphin.setZza(0.0f);
            }
        }
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final FinlessPorpoiseEntity dolphin;
        private final double speed;
        private Player targetPlayer;

        SwimWithPlayerGoal(FinlessPorpoiseEntity dolphinIn, double speedIn) {
            this.dolphin = dolphinIn;
            this.speed = speedIn;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.targetPlayer = this.dolphin.level().getNearestPlayer(PLAYER_PREDICATE, (LivingEntity)this.dolphin);
            if (this.targetPlayer == null) {
                return false;
            }
            return this.targetPlayer.isSwimming() && this.dolphin.getTarget() != this.targetPlayer;
        }

        public boolean canContinueToUse() {
            return this.targetPlayer != null && this.dolphin.getTarget() != this.targetPlayer && this.targetPlayer.isSwimming() && this.dolphin.distanceToSqr((Entity)this.targetPlayer) < 256.0;
        }

        public void start() {
        }

        public void stop() {
            this.targetPlayer = null;
            this.dolphin.getNavigation().stop();
        }

        public void tick() {
            this.dolphin.getLookControl().setLookAt((Entity)this.targetPlayer, (float)(this.dolphin.getMaxHeadYRot() + 20), (float)this.dolphin.getMaxHeadXRot());
            if (this.dolphin.distanceToSqr((Entity)this.targetPlayer) < 10.0) {
                this.dolphin.getNavigation().stop();
            } else {
                this.dolphin.getNavigation().moveTo((Entity)this.targetPlayer, this.speed);
            }
            if (this.targetPlayer.isSwimming() && this.targetPlayer.level().random.nextInt(6) == 0) {
                this.targetPlayer.addEffect(new MobEffectInstance(AbyssoulsWildlifeModMobEffects.FINLESS_PORPOISES_SMILE, 1000));
            }
        }
    }
}

