/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.abyssoul.abyssoulswildlife.entity.WhitetipReefSharkEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.SwimDeepGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperConsumeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperHavefoodProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperHurtProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperOntickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GiantGrouperRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaKillOtherProcedure;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class GiantGrouperEntity
extends TamableAnimal
implements Bucketable {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_targetx = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targety = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetz = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_havefoodentitytype = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<CompoundTag> SWALLOWED_ENTITY_DATA = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<Integer> DATA_consumetime = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(GiantGrouperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public GiantGrouperEntity(EntityType<GiantGrouperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (GiantGrouperEntity.this.isInWater()) {
                    GiantGrouperEntity.this.setDeltaMovement(GiantGrouperEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !GiantGrouperEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - GiantGrouperEntity.this.getX();
                    double dy = this.wantedY - GiantGrouperEntity.this.getY();
                    double dz = this.wantedZ - GiantGrouperEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * GiantGrouperEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    GiantGrouperEntity.this.setYRot(this.rotlerp(GiantGrouperEntity.this.getYRot(), f, 10.0f));
                    GiantGrouperEntity.this.yBodyRot = GiantGrouperEntity.this.getYRot();
                    GiantGrouperEntity.this.yHeadRot = GiantGrouperEntity.this.getYRot();
                    if (GiantGrouperEntity.this.isInWater()) {
                        GiantGrouperEntity.this.setSpeed((float)GiantGrouperEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        GiantGrouperEntity.this.setXRot(this.rotlerp(GiantGrouperEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(GiantGrouperEntity.this.getXRot() * ((float)Math.PI / 180)));
                        GiantGrouperEntity.this.setZza(f3 * f1);
                        GiantGrouperEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        GiantGrouperEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    GiantGrouperEntity.this.setSpeed(0.0f);
                    GiantGrouperEntity.this.setYya(0.0f);
                    GiantGrouperEntity.this.setZza(0.0f);
                }
            }
        };
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)AbyssoulsWildlifeModItems.GIANT_GROUPER_BUCKET.get());
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean bucketed) {
        this.entityData.set(FROM_BUCKET, (Object)bucketed);
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compound);
        if (compound.hasUUID("Owner")) {
            this.setOwnerUUID(compound.getUUID("Owner"));
        }
        this.setTame(compound.getBoolean("Tamed"), true);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("Datatargetx")) {
            this.entityData.set(DATA_targetx, (Object)compound.getInt("Datatargetx"));
        }
        if (compound.contains("Datatargety")) {
            this.entityData.set(DATA_targety, (Object)compound.getInt("Datatargety"));
        }
        if (compound.contains("Datatargetz")) {
            this.entityData.set(DATA_targetz, (Object)compound.getInt("Datatargetz"));
        }
        if (compound.contains("Datahavefoodentitytype")) {
            this.entityData.set(DATA_havefoodentitytype, (Object)compound.getString("Datahavefoodentitytype"));
        }
        if (compound.contains("ContainedData")) {
            this.entityData.set(SWALLOWED_ENTITY_DATA, (Object)compound.getCompound("ContainedData"));
        }
        if (compound.contains("Dataconsumetime")) {
            this.entityData.set(DATA_consumetime, (Object)compound.getInt("Dataconsumetime"));
        }
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
        if (this.getOwnerUUID() != null) {
            CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putUUID("Owner", this.getOwnerUUID()));
        }
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putBoolean("Tamed", this.isTame()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction)));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState)));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putInt("Datatargetx", ((Integer)this.entityData.get(DATA_targetx)).intValue()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putInt("Datatargety", ((Integer)this.entityData.get(DATA_targety)).intValue()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putInt("Datatargetz", ((Integer)this.entityData.get(DATA_targetz)).intValue()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.put("ContainedData", (Tag)this.entityData.get(SWALLOWED_ENTITY_DATA)));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putInt("Dataconsumetime", ((Integer)this.entityData.get(DATA_consumetime)).intValue()));
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, p_331150_ -> p_331150_.putBoolean("FromBucket", this.fromBucket()));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_targetx, (Object)0);
        builder.define(DATA_targety, (Object)0);
        builder.define(DATA_targetz, (Object)0);
        builder.define(DATA_havefoodentitytype, (Object)"");
        builder.define(SWALLOWED_ENTITY_DATA, (Object)new CompoundTag());
        builder.define(DATA_consumetime, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, WhitetipReefSharkEntity.class, true, true){

            public boolean canUse() {
                double x = GiantGrouperEntity.this.getX();
                double y = GiantGrouperEntity.this.getY();
                double z = GiantGrouperEntity.this.getZ();
                GiantGrouperEntity entity = GiantGrouperEntity.this;
                Level world = GiantGrouperEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 6, true, true, null){

            public boolean canUse() {
                GiantGrouperEntity entity = GiantGrouperEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }

            protected double getFollowDistance() {
                return 6.0;
            }
        });
        this.goalSelector.addGoal(5, (Goal)new SwimDeepGoal((PathfinderMob)this, 0.9, 20));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GiantGrouperEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        GiantGrouperHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
        compound.putBoolean("Tamed", this.isTame());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("Datatargetx", ((Integer)this.entityData.get(DATA_targetx)).intValue());
        compound.putInt("Datatargety", ((Integer)this.entityData.get(DATA_targety)).intValue());
        compound.putInt("Datatargetz", ((Integer)this.entityData.get(DATA_targetz)).intValue());
        compound.putString("Datahavefoodentitytype", (String)this.entityData.get(DATA_havefoodentitytype));
        compound.put("ContainedData", (Tag)this.entityData.get(SWALLOWED_ENTITY_DATA));
        compound.putInt("Dataconsumetime", ((Integer)this.entityData.get(DATA_consumetime)).intValue());
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            this.setOwnerUUID(compound.getUUID("Owner"));
        }
        this.setTame(compound.getBoolean("Tamed"), true);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("Datatargetx")) {
            this.entityData.set(DATA_targetx, (Object)compound.getInt("Datatargetx"));
        }
        if (compound.contains("Datatargety")) {
            this.entityData.set(DATA_targety, (Object)compound.getInt("Datatargety"));
        }
        if (compound.contains("Datatargetz")) {
            this.entityData.set(DATA_targetz, (Object)compound.getInt("Datatargetz"));
        }
        if (compound.contains("Datahavefoodentitytype")) {
            this.entityData.set(DATA_havefoodentitytype, (Object)compound.getString("Datahavefoodentitytype"));
        }
        if (compound.contains("ContainedData")) {
            this.entityData.set(SWALLOWED_ENTITY_DATA, (Object)compound.getCompound("ContainedData"));
        }
        if (compound.contains("Dataconsumetime")) {
            this.entityData.set(DATA_consumetime, (Object)compound.getInt("Dataconsumetime"));
        }
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    @Nonnull
    public InteractionResult mobInteract(@Nonnull Player sourceentity, @Nonnull InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = Bucketable.bucketMobPickup((Player)sourceentity, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(sourceentity, hand));
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        GiantGrouperEntity entity = this;
                        Level world = this.level();
                        return GiantGrouperRightClickProcedure.execute(x, y, z, (Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(9) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        OrcaKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(GiantGrouperBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GiantGrouperConsumeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GiantGrouperHavefoodProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GiantGrouperOntickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        GiantGrouperEntity retval = (GiantGrouperEntity)((EntityType)AbyssoulsWildlifeModEntities.GIANT_GROUPER.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:fishes"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GiantGrouperEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GiantGrouperEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.2);
        builder = builder.add(Attributes.MAX_HEALTH, 45.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 4.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.7);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.2);
        return builder;
    }

    static class OwnerHurtTargetGoal
    extends TargetGoal {
        private final TamableAnimal tameAnimal;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public OwnerHurtTargetGoal(TamableAnimal p_26114_) {
            super((Mob)p_26114_, false);
            this.tameAnimal = p_26114_;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            if (this.tameAnimal.isTame() && !this.tameAnimal.isOrderedToSit()) {
                LivingEntity livingentity = this.tameAnimal.getOwner();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurt = livingentity.getLastHurtMob();
                int i = livingentity.getLastHurtMobTimestamp();
                return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT) && this.tameAnimal.wantsToAttack(this.ownerLastHurt, livingentity) && (this.ownerLastHurt.getBbWidth() * this.ownerLastHurt.getBbHeight() <= 2.0f || (double)this.ownerLastHurt.getHealth() <= (double)this.ownerLastHurt.getMaxHealth() * 0.5 && this.ownerLastHurt.getBbWidth() * this.ownerLastHurt.getBbHeight() <= 8.0f);
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurt);
            LivingEntity livingentity = this.tameAnimal.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }

    static class OwnerHurtByTargetGoal
    extends TargetGoal {
        private final TamableAnimal tameAnimal;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public OwnerHurtByTargetGoal(TamableAnimal p_26107_) {
            super((Mob)p_26107_, false);
            this.tameAnimal = p_26107_;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            if (this.tameAnimal.isTame() && !this.tameAnimal.isOrderedToSit()) {
                LivingEntity livingentity = this.tameAnimal.getOwner();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurtBy = livingentity.getLastHurtByMob();
                int i = livingentity.getLastHurtMobTimestamp();
                return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && this.tameAnimal.wantsToAttack(this.ownerLastHurtBy, livingentity) && (this.ownerLastHurtBy.getBbWidth() * this.ownerLastHurtBy.getBbHeight() <= 2.0f || (double)this.ownerLastHurtBy.getHealth() <= (double)this.ownerLastHurtBy.getMaxHealth() * 0.5 && this.ownerLastHurtBy.getBbWidth() * this.ownerLastHurtBy.getBbHeight() <= 8.0f);
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurtBy);
            LivingEntity livingentity = this.tameAnimal.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }
}

