/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.ai.DirectPathNavigator;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.CondorNoOnLandProcedure;
import net.abyssoul.abyssoulswildlife.procedures.CondorOnLandProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleBeakAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleClawAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleDashProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GoldenEagleShouldFlyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GoldenEagleEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(GoldenEagleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(GoldenEagleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(GoldenEagleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_Flytime = SynchedEntityData.defineId(GoldenEagleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    private boolean isLandNavigator;

    public GoldenEagleEntity(EntityType<GoldenEagleEntity> type, Level world) {
        super(type, world);
        this.switchNavigator(true);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new MoveHelper(this);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_Flytime, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(5, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, 200, true, true, p_28879_ -> {
            TamableAnimal tamable;
            return p_28879_ instanceof TamableAnimal && !(tamable = (TamableAnimal)p_28879_).isTame();
        }){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 100, true, true, p_28879_ -> p_28879_ instanceof LivingEntity){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, 100, true, true, p_28879_ -> p_28879_ instanceof LivingEntity){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, 100, true, true, p_28879_ -> p_28879_ instanceof LivingEntity){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.5, 20){

            protected Vec3 getPosition() {
                RandomSource random = GoldenEagleEntity.this.getRandom();
                double dir_x = GoldenEagleEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = GoldenEagleEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = GoldenEagleEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleShouldFlyProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = GoldenEagleEntity.this.getX();
                double y = GoldenEagleEntity.this.getY();
                double z = GoldenEagleEntity.this.getZ();
                GoldenEagleEntity entity = GoldenEagleEntity.this;
                Level world = GoldenEagleEntity.this.level();
                return super.canUse() && GoldenEagleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new FloatGoal((Mob)this));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)(-entity.getBbHeight() - 0.5f), 0.0);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:goldeneagle_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:goldeneagle_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:goldeneagle_death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("DataFlytime", ((Integer)this.entityData.get(DATA_Flytime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("DataFlytime")) {
            this.entityData.set(DATA_Flytime, (Object)compound.getInt("DataFlytime"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        GoldenEagleEntity entity = this;
                        Level world = this.level();
                        return GoldenEagleRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(9) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (GoldenEagleShouldFlyProcedure.execute((Entity)this)) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(CondorOnLandProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CondorNoOnLandProcedure.execute((Entity)this) && !GoldenEagleDashProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GoldenEagleBeakAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(GoldenEagleClawAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(GoldenEagleDashProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GoldenEagleOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        GoldenEagleEntity retval = (GoldenEagleEntity)((EntityType)AbyssoulsWildlifeModEntities.GOLDEN_EAGLE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:meat"))).test(stack);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 18.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 4.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }

    static class MoveHelper
    extends MoveControl {
        private final GoldenEagleEntity parentEntity;

        public MoveHelper(GoldenEagleEntity bird) {
            super((Mob)bird);
            this.parentEntity = bird;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d5 = vector3d.length();
                if (d5 < 0.3) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                } else {
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * 0.05 / d5)));
                    Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }
}

