/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.OrcaEntity;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteIshungryProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteIsnotTamedProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteOntickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteScaleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteStrandedAnimProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class GreatWhiteEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetx = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targety = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetz = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfx = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfy = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfz = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hunger = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_skintype = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Scale = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(GreatWhiteEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public GreatWhiteEntity(EntityType<GreatWhiteEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (GreatWhiteEntity.this.isInWater()) {
                    GreatWhiteEntity.this.setDeltaMovement(GreatWhiteEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !GreatWhiteEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - GreatWhiteEntity.this.getX();
                    double dy = this.wantedY - GreatWhiteEntity.this.getY();
                    double dz = this.wantedZ - GreatWhiteEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * GreatWhiteEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    GreatWhiteEntity.this.setYRot(this.rotlerp(GreatWhiteEntity.this.getYRot(), f, 10.0f));
                    GreatWhiteEntity.this.yBodyRot = GreatWhiteEntity.this.getYRot();
                    GreatWhiteEntity.this.yHeadRot = GreatWhiteEntity.this.getYRot();
                    if (GreatWhiteEntity.this.isInWater()) {
                        GreatWhiteEntity.this.setSpeed((float)GreatWhiteEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        GreatWhiteEntity.this.setXRot(this.rotlerp(GreatWhiteEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(GreatWhiteEntity.this.getXRot() * ((float)Math.PI / 180)));
                        GreatWhiteEntity.this.setZza(f3 * f1);
                        GreatWhiteEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        GreatWhiteEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    GreatWhiteEntity.this.setSpeed(0.0f);
                    GreatWhiteEntity.this.setYya(0.0f);
                    GreatWhiteEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_targetx, (Object)0);
        builder.define(DATA_targety, (Object)0);
        builder.define(DATA_targetz, (Object)0);
        builder.define(DATA_selfx, (Object)0);
        builder.define(DATA_selfy, (Object)0);
        builder.define(DATA_selfz, (Object)0);
        builder.define(DATA_hunger, (Object)20);
        builder.define(DATA_skintype, (Object)0);
        builder.define(DATA_Scale, (Object)1);
        builder.define(DATA_FollowState, (Object)"free");
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, p_28879_ -> {
            if (!(p_28879_ instanceof LivingEntity)) return false;
            LivingEntity liv = (LivingEntity)p_28879_;
            if (p_28879_ instanceof GreatWhiteEntity) return false;
            if (p_28879_ instanceof OrcaEntity) return false;
            if (!(liv.getHealth() < this.getHealth())) return false;
            return true;
        }){

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteIshungryProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal<OrcaEntity>((PathfinderMob)this, OrcaEntity.class, 48.0f, 1.0, 0.8){

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 40){

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = GreatWhiteEntity.this.getX();
                double y = GreatWhiteEntity.this.getY();
                double z = GreatWhiteEntity.this.getZ();
                GreatWhiteEntity entity = GreatWhiteEntity.this;
                Level world = GreatWhiteEntity.this.level();
                return super.canUse() && GreatWhiteFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        GreatWhiteSpawnProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("Datatargetx", ((Integer)this.entityData.get(DATA_targetx)).intValue());
        compound.putInt("Datatargety", ((Integer)this.entityData.get(DATA_targety)).intValue());
        compound.putInt("Datatargetz", ((Integer)this.entityData.get(DATA_targetz)).intValue());
        compound.putInt("Dataselfx", ((Integer)this.entityData.get(DATA_selfx)).intValue());
        compound.putInt("Dataselfy", ((Integer)this.entityData.get(DATA_selfy)).intValue());
        compound.putInt("Dataselfz", ((Integer)this.entityData.get(DATA_selfz)).intValue());
        compound.putInt("Datahunger", ((Integer)this.entityData.get(DATA_hunger)).intValue());
        compound.putInt("Dataskintype", ((Integer)this.entityData.get(DATA_skintype)).intValue());
        compound.putInt("DataScale", ((Integer)this.entityData.get(DATA_Scale)).intValue());
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("Datatargetx")) {
            this.entityData.set(DATA_targetx, (Object)compound.getInt("Datatargetx"));
        }
        if (compound.contains("Datatargety")) {
            this.entityData.set(DATA_targety, (Object)compound.getInt("Datatargety"));
        }
        if (compound.contains("Datatargetz")) {
            this.entityData.set(DATA_targetz, (Object)compound.getInt("Datatargetz"));
        }
        if (compound.contains("Dataselfx")) {
            this.entityData.set(DATA_selfx, (Object)compound.getInt("Dataselfx"));
        }
        if (compound.contains("Dataselfy")) {
            this.entityData.set(DATA_selfy, (Object)compound.getInt("Dataselfy"));
        }
        if (compound.contains("Dataselfz")) {
            this.entityData.set(DATA_selfz, (Object)compound.getInt("Dataselfz"));
        }
        if (compound.contains("Datahunger")) {
            this.entityData.set(DATA_hunger, (Object)compound.getInt("Datahunger"));
        }
        if (compound.contains("Dataskintype")) {
            this.entityData.set(DATA_skintype, (Object)compound.getInt("Dataskintype"));
        }
        if (compound.contains("DataScale")) {
            this.entityData.set(DATA_Scale, (Object)compound.getInt("DataScale"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        GreatWhiteEntity entity = this;
                        Level world = this.level();
                        return GreatWhiteRightClickProcedure.execute(x, y, z, (Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        GreatWhiteKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(GreatWhiteBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GreatWhiteStrandedAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GreatWhiteChargeAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GreatWhiteOntickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        GreatWhiteEntity retval = (GreatWhiteEntity)((EntityType)AbyssoulsWildlifeModEntities.GREAT_WHITE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.GUARDIAN_MEAT.get())}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GreatWhiteEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GreatWhiteEntity entity = this;
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        GreatWhiteEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)GreatWhiteScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.5);
        builder = builder.add(Attributes.MAX_HEALTH, 60.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.8);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }
}

