/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.BossEntity;
import net.abyssoul.abyssoulswildlife.entity.SeablueGuardianEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedHurtByTargetGoal;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedRandomSwimming;
import net.abyssoul.abyssoulswildlife.procedures.DeathProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonChaseStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonExecutionAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonFinalkillAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonLaserAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonLaserNochargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonRageAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonRipapartAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonShortdashAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonSpitAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonSuckAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonTailswip2AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HerculodonTailswipAnimProcedure;
import net.abyssoul.abyssoulswildlife.server.CustomServerBossEvent;
import net.abyssoul.abyssoulswildlife.server.MessageMusic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;

public class HerculodonEntity
extends BossEntity {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_tickSinceCombat = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_finalkillCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Phase = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_chargeCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homex = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homey = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_homez = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_laserCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_tailswipCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_suckCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spitCooldown = SynchedEntityData.defineId(HerculodonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    public final AnimationState animationState10 = new AnimationState();
    public final AnimationState animationState11 = new AnimationState();
    public final AnimationState animationState12 = new AnimationState();
    public final AnimationState animationState13 = new AnimationState();
    public final AnimationState animationState14 = new AnimationState();
    public int bossDeathTime = 0;
    private final CustomServerBossEvent bossInfo = new CustomServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, false, 1);

    public HerculodonEntity(EntityType<HerculodonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 600;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (HerculodonEntity.this.isInWater()) {
                    HerculodonEntity.this.setDeltaMovement(HerculodonEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !HerculodonEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - HerculodonEntity.this.getX();
                    double dy = this.wantedY - HerculodonEntity.this.getY();
                    double dz = this.wantedZ - HerculodonEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * HerculodonEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    HerculodonEntity.this.setYRot(this.rotlerp(HerculodonEntity.this.getYRot(), f, 10.0f));
                    HerculodonEntity.this.yBodyRot = HerculodonEntity.this.getYRot();
                    HerculodonEntity.this.yHeadRot = HerculodonEntity.this.getYRot();
                    if (HerculodonEntity.this.isInWater()) {
                        HerculodonEntity.this.setSpeed((float)HerculodonEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        HerculodonEntity.this.setXRot(this.rotlerp(HerculodonEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(HerculodonEntity.this.getXRot() * ((float)Math.PI / 180)));
                        HerculodonEntity.this.setZza(f3 * f1);
                        HerculodonEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        HerculodonEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    HerculodonEntity.this.setSpeed(0.0f);
                    HerculodonEntity.this.setYya(0.0f);
                    HerculodonEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_tickSinceCombat, (Object)200);
        builder.define(DATA_finalkillCooldown, (Object)0);
        builder.define(DATA_Phase, (Object)0);
        builder.define(DATA_chargeCooldown, (Object)0);
        builder.define(DATA_homex, (Object)0);
        builder.define(DATA_homey, (Object)0);
        builder.define(DATA_homez, (Object)0);
        builder.define(DATA_laserCooldown, (Object)0);
        builder.define(DATA_tailswipCooldown, (Object)0);
        builder.define(DATA_suckCooldown, (Object)0);
        builder.define(DATA_spitCooldown, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void tickDeath() {
        ++this.bossDeathTime;
        if (this.bossDeathTime >= 120 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new AdvancedHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = HerculodonEntity.this.getX();
                double y = HerculodonEntity.this.getY();
                double z = HerculodonEntity.this.getZ();
                HerculodonEntity entity = HerculodonEntity.this;
                Level world = HerculodonEntity.this.level();
                return super.canUse() && HerculodonChaseStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean canUse() {
                double x = HerculodonEntity.this.getX();
                double y = HerculodonEntity.this.getY();
                double z = HerculodonEntity.this.getZ();
                HerculodonEntity entity = HerculodonEntity.this;
                Level world = HerculodonEntity.this.level();
                return super.canUse() && HerculodonFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AdvancedRandomSwimming((PathfinderMob)this, 0.8, 5, 48, 7, true){

            @Override
            public boolean canUse() {
                double x = HerculodonEntity.this.getX();
                double y = HerculodonEntity.this.getY();
                double z = HerculodonEntity.this.getZ();
                HerculodonEntity entity = HerculodonEntity.this;
                Level world = HerculodonEntity.this.level();
                return super.canUse() && HerculodonFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.1f + 0.4f;
    }

    protected float getSoundVolume() {
        return 3.0f;
    }

    @Override
    protected boolean canPlayMusic() {
        return true;
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:herculodon_bossmusic"));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.getBossMusic() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessageMusic(this.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getEntity() instanceof SeablueGuardianEntity) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!damagesource.is(DamageTypes.FELL_OUT_OF_WORLD) && amount > 25.0f) {
            amount = 25.0f;
        }
        float reductionFactor = 0.05f * (float)(this.tickCount - this.getLastHurtByMobTimestamp());
        return super.hurt(damagesource, amount *= Math.min(Math.abs(reductionFactor), 1.0f));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("DatatickSinceCombat", ((Integer)this.entityData.get(DATA_tickSinceCombat)).intValue());
        compound.putInt("DatafinalkillCooldown", ((Integer)this.entityData.get(DATA_finalkillCooldown)).intValue());
        compound.putInt("DataPhase", ((Integer)this.entityData.get(DATA_Phase)).intValue());
        compound.putInt("DatachargeCooldown", ((Integer)this.entityData.get(DATA_chargeCooldown)).intValue());
        compound.putInt("Datahomex", ((Integer)this.entityData.get(DATA_homex)).intValue());
        compound.putInt("Datahomey", ((Integer)this.entityData.get(DATA_homey)).intValue());
        compound.putInt("Datahomez", ((Integer)this.entityData.get(DATA_homez)).intValue());
        compound.putInt("DatalaserCooldown", ((Integer)this.entityData.get(DATA_laserCooldown)).intValue());
        compound.putInt("DatatailswipCooldown", ((Integer)this.entityData.get(DATA_tailswipCooldown)).intValue());
        compound.putInt("DatasuckCooldown", ((Integer)this.entityData.get(DATA_suckCooldown)).intValue());
        compound.putInt("DataspitCooldown", ((Integer)this.entityData.get(DATA_spitCooldown)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DatatickSinceCombat")) {
            this.entityData.set(DATA_tickSinceCombat, (Object)compound.getInt("DatatickSinceCombat"));
        }
        if (compound.contains("DatafinalkillCooldown")) {
            this.entityData.set(DATA_finalkillCooldown, (Object)compound.getInt("DatafinalkillCooldown"));
        }
        if (compound.contains("DataPhase")) {
            this.entityData.set(DATA_Phase, (Object)compound.getInt("DataPhase"));
        }
        if (compound.contains("DatachargeCooldown")) {
            this.entityData.set(DATA_chargeCooldown, (Object)compound.getInt("DatachargeCooldown"));
        }
        if (compound.contains("Datahomex")) {
            this.entityData.set(DATA_homex, (Object)compound.getInt("Datahomex"));
        }
        if (compound.contains("Datahomey")) {
            this.entityData.set(DATA_homey, (Object)compound.getInt("Datahomey"));
        }
        if (compound.contains("Datahomez")) {
            this.entityData.set(DATA_homez, (Object)compound.getInt("Datahomez"));
        }
        if (compound.contains("DatalaserCooldown")) {
            this.entityData.set(DATA_laserCooldown, (Object)compound.getInt("DatalaserCooldown"));
        }
        if (compound.contains("DatatailswipCooldown")) {
            this.entityData.set(DATA_tailswipCooldown, (Object)compound.getInt("DatatailswipCooldown"));
        }
        if (compound.contains("DatasuckCooldown")) {
            this.entityData.set(DATA_suckCooldown, (Object)compound.getInt("DatasuckCooldown"));
        }
        if (compound.contains("DataspitCooldown")) {
            this.entityData.set(DATA_spitCooldown, (Object)compound.getInt("DataspitCooldown"));
        }
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        if (entity instanceof LivingEntity) {
            LivingEntity liv = (LivingEntity)entity;
            this.setHealth(this.getHealth() + liv.getMaxHealth());
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(HerculodonBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(HerculodonRageAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(DeathProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(HerculodonSuckAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(HerculodonShortdashAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(HerculodonChargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(HerculodonLaserAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(HerculodonLaserNochargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(HerculodonTailswipAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState10.animateWhen(HerculodonTailswip2AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState11.animateWhen(HerculodonRipapartAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState12.animateWhen(HerculodonExecutionAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState13.animateWhen(HerculodonFinalkillAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState14.animateWhen(HerculodonSpitAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void baseTick() {
        super.baseTick();
        boolean flag = false;
        int l = Mth.floor((float)(this.getBbWidth() / 2.0f + 1.0f));
        int i1 = Mth.floor((float)this.getBbHeight());
        for (BlockPos blockpos : BlockPos.betweenClosed((int)(this.getBlockX() - l), (int)this.getBlockY(), (int)(this.getBlockZ() - l), (int)(this.getBlockX() + l), (int)(this.getBlockY() + i1), (int)(this.getBlockZ() + l))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!blockstate.canEntityDestroy((BlockGetter)this.level(), blockpos, (Entity)this) || blockstate.is(BlockTags.WITHER_IMMUNE) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            flag = this.level().destroyBlock(blockpos, false, (Entity)this) || flag;
        }
        HerculodonOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDisableShield() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HerculodonEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HerculodonEntity entity = this;
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.getEntityData().set(DATA_homex, (Object)((int)this.getX()));
        this.getEntityData().set(DATA_homey, (Object)((int)this.getY()));
        this.getEntityData().set(DATA_homez, (Object)((int)this.getZ()));
        return retval;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 4.0);
        builder = builder.add(Attributes.MAX_HEALTH, 550.0);
        builder = builder.add(Attributes.ARMOR, 12.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 36.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 80.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 4.0);
        return builder;
    }
}

