/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.abyssoul.abyssoulswildlife.entity.HerculodonEntity;
import net.abyssoul.abyssoulswildlife.entity.SeablueGuardianEntity;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModAttributes;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;

public class HerculodonLaserEntity
extends Entity {
    public LivingEntity caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public int appear = 1;
    public boolean on = true;
    public Direction blockSide = null;
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> BEAMDIRECTION = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HPDAMAGE = SynchedEntityData.defineId(HerculodonLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float prevYaw;
    public float prevPitch;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void tick() {
        super.tick();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.tickCount == 1 && this.level().isClientSide) {
            this.caster = (LivingEntity)this.level().getEntity(this.getCasterID());
        }
        if (!this.level().isClientSide) {
            this.setYaw((float)((double)(this.caster.yHeadRot + this.getBeamDirection()) * Math.PI / 180.0));
            this.setPitch((float)((double)(-this.caster.getXRot()) * Math.PI / 180.0));
            float f = -Mth.sin((float)(this.caster.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.caster.getXRot() * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(this.caster.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.caster.getXRot() * ((float)Math.PI / 180)));
            if (this.caster instanceof SeablueGuardianEntity) {
                this.setPos(this.caster.getX(), this.caster.getY(), this.caster.getZ());
            } else if (this.caster instanceof ServerPlayer) {
                this.setPos(this.caster.getX(), this.caster.getY() + (double)1.2f, this.caster.getZ());
            } else {
                this.setPos(this.caster.getX(), this.caster.getY() + (double)1.4f, this.caster.getZ());
            }
        }
        if (this.caster != null) {
            this.renderYaw = (float)((double)(this.caster.yHeadRot + this.getBeamDirection()) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-this.caster.getXRot()) * Math.PI / 180.0);
        }
        if (!this.on && this.appear == 0) {
            this.discard();
        }
        this.appear = this.on && this.tickCount > 5 ? Math.min(this.appear + 1, 3) : Math.max(this.appear - 1, 0);
        if (this.caster != null && !this.caster.isAlive()) {
            this.discard();
        }
        if (this.tickCount > 5) {
            this.calculateEndPos();
            List<LivingEntity> hit = this.raytraceEntities((Level)this.level(), (Vec3)new Vec3((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ)).entities;
            if (this.blockSide != null) {
                if (this.level() instanceof ServerLevel) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)((SimpleParticleType)AbyssoulsWildlifeModParticleTypes.ELECTRICSTREAM.get()), this.collidePosX, this.collidePosY, this.collidePosZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (!this.level().isClientSide) {
                    for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)(this.collidePosX - 0.5)), (int)Mth.floor((double)(this.collidePosY - 0.5)), (int)Mth.floor((double)(this.collidePosZ - 0.5)), (int)Mth.floor((double)(this.collidePosX + 0.5)), (int)Mth.floor((double)(this.collidePosY + 0.5)), (int)Mth.floor((double)(this.collidePosZ + 0.5)))) {
                        BlockState block = this.level().getBlockState(pos);
                        if (block.isAir() || block.is(BlockTags.WITHER_IMMUNE) || !(this.caster instanceof HerculodonEntity) || !EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) continue;
                        this.level().destroyBlock(pos, false);
                    }
                }
            }
            if (!this.level().isClientSide) {
                Level world = this.level();
                for (LivingEntity target : hit) {
                    LivingEntity liv;
                    boolean flag;
                    if (this.caster == null || this.caster.isAlliedTo((Entity)target) || target == this.caster || !(flag = target.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MAGIC), (Entity)this.caster), this.getDamage())) || !(target instanceof LivingEntity) || !(liv = target).getAttributes().hasAttribute(AbyssoulsWildlifeModAttributes.HP_PERCENTAGE)) continue;
                    liv.getAttribute(AbyssoulsWildlifeModAttributes.HP_PERCENTAGE).setBaseValue(liv.getAttribute(AbyssoulsWildlifeModAttributes.HP_PERCENTAGE).getBaseValue() - (double)(100.0f * this.getHpDamage()));
                }
            }
        }
        if (this.tickCount - 5 > this.getDuration()) {
            this.on = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326229_) {
        p_326229_.define(YAW, (Object)Float.valueOf(0.0f));
        p_326229_.define(PITCH, (Object)Float.valueOf(0.0f));
        p_326229_.define(DURATION, (Object)0);
        p_326229_.define(CASTER, (Object)-1);
        p_326229_.define(BEAMDIRECTION, (Object)Float.valueOf(90.0f));
        p_326229_.define(DAMAGE, (Object)Float.valueOf(0.0f));
        p_326229_.define(HPDAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getHpDamage() {
        return ((Float)this.entityData.get(HPDAMAGE)).floatValue();
    }

    public void setHpDamage(float damage) {
        this.entityData.set(HPDAMAGE, (Object)Float.valueOf(damage));
    }

    public float getYaw() {
        return ((Float)this.entityData.get(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.entityData.set(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.entityData.get(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.entityData.set(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public void setDuration(int duration) {
        this.entityData.set(DURATION, (Object)duration);
    }

    public float getBeamDirection() {
        return ((Float)this.entityData.get(BEAMDIRECTION)).floatValue();
    }

    public void setBeamDirection(float beamDirection) {
        this.entityData.set(BEAMDIRECTION, (Object)Float.valueOf(beamDirection));
    }

    public int getCasterID() {
        return (Integer)this.entityData.get(CASTER);
    }

    public void setCasterID(int id) {
        this.entityData.set(CASTER, (Object)id);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setYaw(compound.getFloat("Yaw"));
        this.setPitch(compound.getFloat("Pitch"));
        this.setDuration(compound.getInt("Duration"));
        this.setBeamDirection(compound.getFloat("BeamDirection"));
        this.setDamage(compound.getFloat("damage"));
        this.setHpDamage(compound.getFloat("Hpdamage"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Yaw", this.getYaw());
        compound.putFloat("Pitch", this.getPitch());
        compound.putInt("Duration", this.getDuration());
        compound.putFloat("BeamDirection", this.getBeamDirection());
        compound.putFloat("damage", this.getDamage());
        compound.putFloat("Hpdamage", this.getHpDamage());
    }

    private void calculateEndPos() {
        double RADIUS = 100.0;
        if (this.level().isClientSide()) {
            this.endPosX = this.getX() + RADIUS * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.getZ() + RADIUS * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.getY() + RADIUS * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.getX() + RADIUS * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.getZ() + RADIUS * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.getY() + RADIUS * Math.sin(this.getPitch());
        }
    }

    public LaserbeamHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        LaserbeamHitResult result = new LaserbeamHitResult();
        result.setBlockHit((HitResult)world.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = result.blockHit.getDirection();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(2.0, 2.0, 2.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.getPickRadius() + 0.5f;
            AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.clip(from, to);
            if (aabb.contains(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public void push(Entity entityIn) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean shouldRender(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_36837_) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36837_ < (d0 *= 64.0) * d0;
    }

    private void updateLaser() {
        this.setYaw((float)((double)(this.caster.yHeadRot + this.getBeamDirection()) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.getXRot()) * Math.PI / 180.0));
        float f = -Mth.sin((float)(this.caster.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.caster.getXRot() * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(this.caster.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.caster.getXRot() * ((float)Math.PI / 180)));
        if (this.caster instanceof SeablueGuardianEntity) {
            this.setPos(this.caster.getX(), this.caster.getY(), this.caster.getZ());
        } else if (this.caster instanceof ServerPlayer) {
            this.setPos(this.caster.getX(), this.caster.getY() + (double)1.2f, this.caster.getZ());
        } else {
            this.setPos(this.caster.getX(), this.caster.getY() + (double)1.4f, this.caster.getZ());
        }
    }

    public HerculodonLaserEntity(EntityType<? extends HerculodonLaserEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
        if (world.isClientSide) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public HerculodonLaserEntity(EntityType<? extends HerculodonLaserEntity> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration, float direction, float damage, float HpPercentdamage) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.setBeamDirection(direction);
        this.setDamage(damage);
        this.setHpDamage(HpPercentdamage);
        this.setPos(x, y, z);
        this.calculateEndPos();
        if (!world.isClientSide) {
            this.setCasterID(caster.getId());
        }
    }

    public static class LaserbeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

